/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsManipulator;
import java.util.ArrayList;
import java.util.List;

public class UselessLessElementsRemover {
    private final SelectorsManipulator manipulator = new SelectorsManipulator();

    public void removeUselessLessElements(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                this.removeFrom((RuleSet)node);
                break;
            }
            case CHARSET_DECLARATION: 
            case IMPORT: {
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.removeUselessLessElements(aSTCssNode);
                }
            }
        }
    }

    public void removeFrom(RuleSet ruleSet) {
        List<Selector> selectors = ruleSet.getSelectors();
        for (Selector selector : selectors) {
            Selector replacement = this.manipulator.removeAppenders(selector);
            if (replacement == selector) continue;
            ruleSet.replaceSelector(selector, replacement);
        }
    }
}

