/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.cmis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.cmis.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class CmisAuthorityConnector
extends BaseAuthorityConnector {
    public static final String CONFIG_PARAM_USERNAME = "username";
    public static final String CONFIG_PARAM_PASSWORD = "password";
    public static final String CONFIG_PARAM_ENDPOINT = "endpoint";
    public static final String CONFIG_PARAM_REPOSITORY_ID = "repositoryId";
    protected static final String CONFIG_PARAM_USERNAME_REGEXP = "usernameregexp";
    protected static final String CONFIG_PARAM_USER_TRANSLATION = "usertranslation";
    private static final String DEFAULT_VALUE_ENDPOINT = "http://localhost:8080/cmis/";
    private static final String DEFAULT_VALUE_REPOSITORY_ID = "uuid";
    protected String endpoint = null;
    protected String repositoryId = null;
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected ICacheManager cacheManager = null;
    protected static long responseLifetime = 60000L;
    protected static int LRUsize = 1000;
    protected static StringSet emptyStringSet = new StringSet();
    public static final String GLOBAL_DENY_TOKEN = "DEAD_AUTHORITY";
    private static final AuthorizationResponse unreachableResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 1);
    private static final AuthorizationResponse userNotFoundResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 2);

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String endpoint = parameters.getParameter(CONFIG_PARAM_ENDPOINT);
        String repositoryId = parameters.getParameter(CONFIG_PARAM_REPOSITORY_ID);
        if (StringUtils.isEmpty((String)endpoint)) {
            endpoint = DEFAULT_VALUE_ENDPOINT;
        }
        if (StringUtils.isEmpty((String)repositoryId)) {
            repositoryId = DEFAULT_VALUE_REPOSITORY_ID;
        }
        if (tabName.equals(Messages.getString(locale, "CmisAuthorityConnector.Repository"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            out.print("<tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "CmisAuthorityConnector.Endpoint") + "</nobr></td><td class=\"value\"><input type=\"text\" name=\"" + CONFIG_PARAM_ENDPOINT + "\" value=\"" + Encoder.attributeEscape((String)endpoint) + "\" size=\"50\"/></td></tr>\n");
            out.print("<tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "CmisAuthorityConnector.RepositoryID") + "</nobr></td><td class=\"value\"><input type=\"text\" name=\"" + CONFIG_PARAM_REPOSITORY_ID + "\" value=\"" + Encoder.attributeEscape((String)repositoryId) + "\"/></td></tr>\n");
            out.print("</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"endpoint\" value=\"" + Encoder.attributeEscape((String)endpoint) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"repositoryId\" value=\"" + Encoder.attributeEscape((String)repositoryId) + "\"/>\n");
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "CmisAuthorityConnector.Repository"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.endpoint.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "CmisAuthorityConnector.TheEndpointMustBeNotNull") + "\");\n    editconnection.endpoint.focus();\n    return false;\n  }\n\n  return true;\n}\n \nfunction checkConfigForSave()\n{\n  if (editconnection.endpoint.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "CmisAuthorityConnector.TheEndpointMustBeNotNull") + "\");\n    editconnection.endpoint.focus();\n    return false;\n  }\n  if (editconnection.repositoryId.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "CmisAuthorityConnector.TheRepositoryIDMustBeNotNull") + "\");\n    editconnection.repositoryId.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String repositoryId;
        String endpoint = variableContext.getParameter(CONFIG_PARAM_ENDPOINT);
        if (StringUtils.isNotEmpty((String)endpoint) && endpoint.length() > 0) {
            parameters.setParameter(CONFIG_PARAM_ENDPOINT, endpoint);
        }
        if (StringUtils.isNotEmpty((String)(repositoryId = variableContext.getParameter(CONFIG_PARAM_REPOSITORY_ID)))) {
            parameters.setParameter(CONFIG_PARAM_REPOSITORY_ID, repositoryId);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "CmisAuthorityConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("</td>\n  </tr>\n</table>\n");
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return unreachableResponse;
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("CMIS: Calculating response access tokens for user '" + userName + "'"));
        }
        String verifiedUserName = userName;
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("CMIS: Mapped user name is '" + verifiedUserName + "'"));
        }
        String[] tokens = new String[]{verifiedUserName};
        return new AuthorizationResponse(tokens, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("CMIS: Received request for user '" + userName + "'"));
        }
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.endpoint, this.repositoryId);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block9: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block9;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected final String userName;
        protected final String endpoint;
        protected final String repositoryId;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, String endpoint, String repositoryId) {
            super("CMISAuthority", LRUsize);
            this.userName = userName;
            this.endpoint = endpoint;
            this.repositoryId = repositoryId;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            return ((Object)((Object)this)).getClass().getName() + "-" + this.userName + "-" + this.endpoint + "-" + this.repositoryId;
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.endpoint.hashCode() + this.repositoryId.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName) && ard.endpoint.equals(this.endpoint) && ard.repositoryId.equals(this.repositoryId);
        }
    }
}

