/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.common.protocol.types.Struct;

public class ClientResponse {
    private final long received;
    private final boolean disconnected;
    private final ClientRequest request;
    private final Struct responseBody;

    public ClientResponse(ClientRequest request, long received, boolean disconnected, Struct responseBody) {
        this.received = received;
        this.disconnected = disconnected;
        this.request = request;
        this.responseBody = responseBody;
    }

    public long receivedTime() {
        return this.received;
    }

    public boolean wasDisconnected() {
        return this.disconnected;
    }

    public ClientRequest request() {
        return this.request;
    }

    public Struct responseBody() {
        return this.responseBody;
    }

    public boolean hasResponse() {
        return this.responseBody != null;
    }

    public long requestLatencyMs() {
        return this.receivedTime() - this.request.createdTime();
    }

    public String toString() {
        return "ClientResponse(received=" + this.received + ", disconnected=" + this.disconnected + ", request=" + this.request + ", responseBody=" + this.responseBody + ")";
    }
}

