/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.ClientRequest;

final class InFlightRequests {
    private final int maxInFlightRequestsPerConnection;
    private final Map<Integer, Deque<ClientRequest>> requests = new HashMap<Integer, Deque<ClientRequest>>();

    public InFlightRequests(int maxInFlightRequestsPerConnection) {
        this.maxInFlightRequestsPerConnection = maxInFlightRequestsPerConnection;
    }

    public void add(ClientRequest request) {
        Deque<ClientRequest> reqs = this.requests.get(request.request().destination());
        if (reqs == null) {
            reqs = new ArrayDeque<ClientRequest>();
            this.requests.put(request.request().destination(), reqs);
        }
        reqs.addFirst(request);
    }

    private Deque<ClientRequest> requestQueue(int node) {
        Deque<ClientRequest> reqs = this.requests.get(node);
        if (reqs == null || reqs.isEmpty()) {
            throw new IllegalStateException("Response from server for which there are no in-flight requests.");
        }
        return reqs;
    }

    public ClientRequest completeNext(int node) {
        return this.requestQueue(node).pollLast();
    }

    public ClientRequest lastSent(int node) {
        return this.requestQueue(node).peekFirst();
    }

    public ClientRequest completeLastSent(int node) {
        return this.requestQueue(node).pollFirst();
    }

    public boolean canSendMore(int node) {
        Deque<ClientRequest> queue = this.requests.get(node);
        return queue == null || queue.isEmpty() || queue.peekFirst().request().completed() && queue.size() < this.maxInFlightRequestsPerConnection;
    }

    public int inFlightRequestCount(int node) {
        Deque<ClientRequest> queue = this.requests.get(node);
        return queue == null ? 0 : queue.size();
    }

    public int inFlightRequestCount() {
        int total = 0;
        for (Deque<ClientRequest> deque : this.requests.values()) {
            total += deque.size();
        }
        return total;
    }

    public Iterable<ClientRequest> clearAll(int node) {
        Deque<ClientRequest> reqs = this.requests.get(node);
        if (reqs == null) {
            return Collections.emptyList();
        }
        return this.requests.remove(node);
    }
}

