/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.cmisoutput;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.output.cmisoutput.ColumnSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CmisOutputConnectorUtils {
    private static final String LOAD_LINK_METHOD_NAME = "loadLink";
    private static final String FROM_TOKEN = "from";
    public static final String SEP = " ";
    private static final String SELECT_STAR_CLAUSE = "select *";
    private static final String OBJECT_ID_TERM = "cmis:objectId,";
    private static final String SELECT_CLAUSE_TERM_SEP = ",";
    private static final String SELECT_PREFIX = "select ";
    private static final String TOKENIZER_SEP = ",\n\t";
    public static final String SLASH = "/";
    public static final String REPLACE = "?";
    public static final String SELECT_FOR_REMOVAL = "SELECT * FROM cmis:document WHERE cmis:name='?'";

    public static final String getDocumentURL(Document document, Session session) throws ManifoldCFException {
        String link = null;
        try {
            Method loadLink = AbstractAtomPubService.class.getDeclaredMethod(LOAD_LINK_METHOD_NAME, String.class, String.class, String.class, String.class);
            loadLink.setAccessible(true);
            link = (String)loadLink.invoke((Object)session.getBinding().getObjectService(), session.getRepositoryInfo().getId(), document.getId(), "@@content@@", null);
        }
        catch (Exception e) {
            Logging.connectors.error((Object)("CMIS: Error during getting the content stream url: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        return link;
    }

    public static String getCmisQueryWithObjectId(String cmisQuery) {
        String cmisQueryResult = "";
        String selectClause = CmisOutputConnectorUtils.getSelectClause(cmisQuery);
        if (selectClause.equalsIgnoreCase(SELECT_STAR_CLAUSE)) {
            cmisQueryResult = cmisQuery;
        } else {
            StringTokenizer selectClauseTokenized = new StringTokenizer(selectClause.trim());
            boolean firstTermSelectClause = true;
            String selectTerm = "";
            String prefix = "";
            boolean foundObjIdClause = false;
            boolean foundPrefixClause = false;
            while (selectClauseTokenized.hasMoreElements()) {
                String term = selectClauseTokenized.nextToken();
                if (firstTermSelectClause) {
                    selectTerm = term;
                    firstTermSelectClause = false;
                    continue;
                }
                if (term.contains("cmis:objectId")) {
                    foundObjIdClause = true;
                    cmisQueryResult = cmisQuery;
                    break;
                }
                if (foundPrefixClause || !term.contains(".")) continue;
                int i = term.indexOf(".");
                prefix = term.substring(0, i);
                foundPrefixClause = true;
            }
            if (!foundObjIdClause) {
                String toReplace = selectTerm + SEP;
                toReplace = foundPrefixClause ? toReplace + prefix + "." + OBJECT_ID_TERM : toReplace + OBJECT_ID_TERM;
                cmisQueryResult = StringUtils.replaceOnce((String)cmisQuery, (String)selectTerm, (String)toReplace);
            }
        }
        return cmisQueryResult;
    }

    public static boolean existsInSelectClause(String cmisQuery, String propertyId) {
        String term;
        String selectClause = CmisOutputConnectorUtils.getSelectClause(cmisQuery);
        if (selectClause.toLowerCase(Locale.ROOT).startsWith(SELECT_STAR_CLAUSE)) {
            return true;
        }
        StringTokenizer cmisQueryTokenized = new StringTokenizer(cmisQuery.trim());
        while (cmisQueryTokenized.hasMoreElements() && !(term = cmisQueryTokenized.nextToken()).equalsIgnoreCase(FROM_TOKEN)) {
            if (term.equalsIgnoreCase(propertyId)) {
                return true;
            }
            if (!StringUtils.contains((String)term, (String)SELECT_CLAUSE_TERM_SEP)) continue;
            StringTokenizer termsTokenized = new StringTokenizer(term, SELECT_CLAUSE_TERM_SEP);
            while (termsTokenized.hasMoreElements()) {
                String termTokenized = termsTokenized.nextToken().trim();
                if (!termTokenized.equalsIgnoreCase(propertyId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addValuesOfProperties(List<Property<?>> props, RepositoryDocument rd, String cmisQuery) {
        Map<String, String> cmisQueryColumns = CmisOutputConnectorUtils.getSelectMap(cmisQuery);
        boolean isWildcardQuery = CmisOutputConnectorUtils.isWildcardQuery(cmisQuery);
        CmisOutputConnectorUtils.addValuesOfProperty(props, isWildcardQuery, cmisQueryColumns, rd);
    }

    public static void addValuesOfProperty(List<Property<?>> props, boolean isWildcardQuery, Map<String, String> cmisQueryColumns, RepositoryDocument rd) {
        for (Property<?> property : props) {
            String propertyId = property.getId();
            if (!isWildcardQuery && !cmisQueryColumns.containsKey(propertyId)) continue;
            try {
                CmisOutputConnectorUtils.addPropertyValue(property, rd);
            }
            catch (Exception e) {
                Logging.connectors.error((Object)("Error when adding property[" + propertyId + "] msg=[" + e.getMessage() + "]"), (Throwable)e);
            }
        }
    }

    private static void addPropertyValue(Property<?> property, RepositoryDocument rd) throws Exception {
        DateTimeFormatter format = ISODateTimeFormat.dateTime();
        PropertyDefinition propertyDefinitionType = property.getDefinition();
        PropertyType propertyType = propertyDefinitionType.getPropertyType();
        boolean isMultiValue = propertyDefinitionType.getCardinality() == Cardinality.MULTI;
        String currentProperty = property.getId();
        switch (propertyType) {
            case STRING: 
            case ID: 
            case URI: 
            case HTML: {
                List listValues = property.getValues();
                if (CollectionUtils.isEmpty((Collection)listValues)) break;
                if (isMultiValue) {
                    for (String htmlPropertyValue : listValues) {
                        rd.addField(currentProperty, htmlPropertyValue);
                    }
                    break;
                }
                String stringValue = (String)listValues.get(0);
                if (!StringUtils.isNotEmpty((String)stringValue)) break;
                rd.addField(currentProperty, stringValue);
                break;
            }
            case BOOLEAN: {
                List booleanPropertyValues = property.getValues();
                if (CollectionUtils.isEmpty((Collection)booleanPropertyValues)) break;
                if (isMultiValue) {
                    for (Boolean booleanPropertyValue : booleanPropertyValues) {
                        rd.addField(currentProperty, booleanPropertyValue.toString());
                    }
                    break;
                }
                Boolean booleanValue = (Boolean)booleanPropertyValues.get(0);
                if (booleanValue == null) break;
                rd.addField(currentProperty, booleanValue.toString());
                break;
            }
            case INTEGER: {
                List integerPropertyValues = property.getValues();
                if (CollectionUtils.isEmpty((Collection)integerPropertyValues)) break;
                if (isMultiValue) {
                    for (BigInteger integerPropertyValue : integerPropertyValues) {
                        rd.addField(currentProperty, integerPropertyValue.toString());
                    }
                    break;
                }
                BigInteger integerValue = (BigInteger)integerPropertyValues.get(0);
                if (integerValue == null) break;
                rd.addField(currentProperty, integerValue.toString());
                break;
            }
            case DECIMAL: {
                List decimalPropertyValues = property.getValues();
                if (CollectionUtils.isEmpty((Collection)decimalPropertyValues)) break;
                if (isMultiValue) {
                    for (BigDecimal decimalPropertyValue : decimalPropertyValues) {
                        rd.addField(currentProperty, decimalPropertyValue.toString());
                    }
                    break;
                }
                BigDecimal decimalValue = (BigDecimal)decimalPropertyValues.get(0);
                if (decimalValue == null) break;
                rd.addField(currentProperty, decimalValue.toString());
                break;
            }
            case DATETIME: {
                List datePropertyValues = property.getValues();
                if (CollectionUtils.isEmpty((Collection)datePropertyValues)) break;
                if (isMultiValue) {
                    for (GregorianCalendar datePropertyValue : datePropertyValues) {
                        rd.addField(currentProperty, format.print(datePropertyValue.getTimeInMillis()));
                    }
                    break;
                }
                GregorianCalendar dateValue = (GregorianCalendar)datePropertyValues.get(0);
                if (dateValue == null) break;
                rd.addField(currentProperty, format.print(dateValue.getTimeInMillis()));
                break;
            }
        }
    }

    private static String getSelectClause(String cmisQuery) {
        String term;
        StringTokenizer cmisQueryTokenized = new StringTokenizer(cmisQuery.trim());
        String selectClause = "";
        boolean firstTerm = true;
        while (cmisQueryTokenized.hasMoreElements() && !(term = cmisQueryTokenized.nextToken()).equalsIgnoreCase(FROM_TOKEN)) {
            if (firstTerm) {
                selectClause = selectClause + term;
                firstTerm = false;
                continue;
            }
            selectClause = selectClause + SEP + term;
        }
        return selectClause;
    }

    public static Map<String, String> getSelectMap(String cmisQuery) {
        HashMap<String, String> cmisQueryColumns = new HashMap<String, String>();
        String selectClause = CmisOutputConnectorUtils.getSelectClause(cmisQuery.trim());
        StringTokenizer cmisQueryTokenized = new StringTokenizer(selectClause.substring(SELECT_PREFIX.length()), TOKENIZER_SEP);
        while (cmisQueryTokenized.hasMoreElements()) {
            String term = cmisQueryTokenized.nextToken();
            ColumnSet column = CmisOutputConnectorUtils.getColumnName(term);
            cmisQueryColumns.put(column.getName(), column.getAlias());
        }
        return cmisQueryColumns;
    }

    private static ColumnSet getColumnName(String orig) {
        String sep = " as ";
        int sepLen = " as ".length();
        String justColumnName = null;
        String alias = null;
        if (orig == null) {
            return null;
        }
        justColumnName = orig.trim();
        int idx = orig.indexOf(" as ");
        if (idx < 0) {
            idx = orig.indexOf(" as ".toUpperCase(Locale.ROOT));
        }
        if (idx > 1) {
            alias = orig.substring(idx + sepLen).trim();
            justColumnName = orig.substring(0, idx).trim();
        }
        if ((idx = justColumnName.indexOf(".")) > 0) {
            justColumnName = justColumnName.substring(idx + 1);
        }
        if (alias == null) {
            alias = justColumnName;
        }
        return new ColumnSet(justColumnName, alias);
    }

    public static boolean isWildcardQuery(String selectClause) {
        return selectClause.toLowerCase(Locale.ROOT).startsWith(SELECT_STAR_CLAUSE);
    }
}

