/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.v6.model;

import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceResource;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.builder.ConfluenceResourceBuilder;
import org.json.simple.JSONObject;

public class ConfluenceRestrictionsResponse<T extends ConfluenceResource> {
    private final T result;
    private final int start;
    private final int limit;
    private final Boolean isLast;

    public ConfluenceRestrictionsResponse(T result, int start, int limit, Boolean isLast) {
        this.result = result;
        this.start = start;
        this.limit = limit;
        this.isLast = isLast;
    }

    public T getResult() {
        return this.result;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public Boolean isLast() {
        return this.isLast;
    }

    public static <T extends ConfluenceResource> ConfluenceRestrictionsResponse<T> fromJson(JSONObject response, ConfluenceResourceBuilder<T> builder) {
        JSONObject restrictions = (JSONObject)response.get((Object)"restrictions");
        JSONObject restrictionsUser = new JSONObject();
        JSONObject restrictionsGroup = new JSONObject();
        if (restrictions.get((Object)"user") != null) {
            restrictionsUser = (JSONObject)restrictions.get((Object)"user");
        }
        if (restrictions.get((Object)"group") != null) {
            restrictionsGroup = (JSONObject)restrictions.get((Object)"group");
        }
        T resource = builder.fromJson(restrictions);
        Boolean isLast = false;
        Boolean isLastUser = false;
        Boolean isLastGroup = false;
        int userLimit = -1;
        int groupLimit = -1;
        int userStart = -1;
        int groupStart = -1;
        if (restrictionsUser.get((Object)"limit") != null) {
            userLimit = ((Long)restrictionsUser.get((Object)"limit")).intValue();
            userStart = ((Long)restrictionsUser.get((Object)"start")).intValue();
            int userSize = ((Long)restrictionsUser.get((Object)"size")).intValue();
            if (userSize < userLimit) {
                isLastUser = true;
            }
        } else {
            isLastUser = true;
        }
        if (restrictionsGroup.get((Object)"limit") != null) {
            groupLimit = ((Long)restrictionsGroup.get((Object)"limit")).intValue();
            groupStart = ((Long)restrictionsGroup.get((Object)"start")).intValue();
            int groupSize = ((Long)restrictionsGroup.get((Object)"size")).intValue();
            if (groupSize < groupLimit) {
                isLastGroup = true;
            }
        } else {
            isLastGroup = true;
        }
        isLast = isLastUser != false && isLastGroup != false;
        int limit = userLimit > -1 ? userLimit : groupLimit;
        int start = userStart > -1 ? userStart : groupStart;
        return new ConfluenceRestrictionsResponse<T>(resource, start, limit, isLast);
    }
}

