/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import kafka.log.LogCleaner$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.metadata.ConfigRepository;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class LogManager$ {
    public static LogManager$ MODULE$;
    private final String LockFileName;
    private final String RecoveryPointCheckpointFile;
    private final String LogStartOffsetCheckpointFile;

    static {
        new LogManager$();
    }

    public String LockFileName() {
        return this.LockFileName;
    }

    public boolean waitForAllToComplete(Seq<Future<?>> jobs, Function1<Throwable, BoxedUnit> callback) {
        return jobs.count((Function1 & Serializable & scala.Serializable)future -> {
            boolean bl;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> future.get());
            if (try_ instanceof Success) {
                bl = false;
            } else if (try_ instanceof Failure) {
                Throwable $anonfun$waitForAllToComplete$1_e = ((Failure)try_).exception();
                callback.apply((Object)$anonfun$waitForAllToComplete$1_e);
                bl = true;
            } else {
                throw new MatchError((Object)try_);
            }
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }) == 0;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return this.LogStartOffsetCheckpointFile;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ConfigRepository configRepository, Scheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, LogDirFailureChannel logDirFailureChannel, boolean keepPartitionMetadataFile) {
        Map<String, Object> defaultProps = config.extractLogConfigMap();
        LogConfig.validateBrokerLogConfigValues(defaultProps, (boolean)Predef$.MODULE$.Boolean2boolean(config.isRemoteLogStorageSystemEnabled()));
        LogConfig defaultLogConfig = new LogConfig(defaultProps);
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        Seq x$1 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$22 -> new File((String)x$22).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom());
        Seq x$2 = (Seq)initialOfflineDirs.map((Function1 & Serializable & scala.Serializable)x$23 -> new File((String)x$23).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom());
        int x$6 = Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir());
        long x$7 = Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs());
        long x$8 = config.logFlushOffsetCheckpointIntervalMs();
        long x$9 = config.logFlushStartOffsetCheckpointIntervalMs();
        long x$10 = Predef$.MODULE$.Long2long(config.logCleanupIntervalMs());
        int x$11 = Predef$.MODULE$.Integer2int(config.transactionMaxTimeoutMs());
        ProducerStateManagerConfig x$12 = new ProducerStateManagerConfig(Predef$.MODULE$.Integer2int(config.producerIdExpirationMs()), Predef$.MODULE$.Boolean2boolean(config.transactionPartitionVerificationEnable()));
        int x$13 = Predef$.MODULE$.Integer2int(config.producerIdExpirationCheckIntervalMs());
        MetadataVersion x$19 = config.interBrokerProtocolVersion();
        boolean x$20 = config.remoteLogManagerConfig().enableRemoteStorageSystem();
        return new LogManager((Seq<File>)x$1, (Seq<File>)x$2, configRepository, defaultLogConfig, cleanerConfig, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$19, kafkaScheduler, brokerTopicStats, logDirFailureChannel, time, keepPartitionMetadataFile, x$20);
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllToComplete$1(Function1 callback$1, Future future) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> future.get());
        if (try_ instanceof Success) {
            return false;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            callback$1.apply((Object)e);
            return true;
        }
        throw new MatchError((Object)try_);
    }

    private LogManager$() {
        MODULE$ = this;
        this.LockFileName = ".lock";
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";
    }
}

