/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.ReadOnlyException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageStorer;
import org.apache.james.mailbox.store.MoveResult;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.StoreMessageResultIterator;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.FetchGroupConverter;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.apache.james.util.io.BodyOffsetInputStream;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StoreMessageManager
implements MessageManager {
    protected static final Flags MINIMAL_PERMANET_FLAGS;
    private static final SearchQuery LIST_ALL_QUERY;
    private static final SearchQuery LIST_FROM_ONE;
    private static final LenientFieldParser FIELD_PARSER;
    private final EnumSet<MailboxManager.MessageCapabilities> messageCapabilities;
    private final EventBus eventBus;
    private final Mailbox mailbox;
    private final MailboxSessionMapperFactory mapperFactory;
    private final MessageSearchIndex index;
    private final StoreRightManager storeRightManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final MailboxPathLocker locker;
    private final BatchSizes batchSizes;
    private final PreDeletionHooks preDeletionHooks;
    private final MessageStorer messageStorer;

    public StoreMessageManager(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities, MailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, EventBus eventBus, MailboxPathLocker locker, Mailbox mailbox, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, BatchSizes batchSizes, StoreRightManager storeRightManager, PreDeletionHooks preDeletionHooks, MessageStorer messageStorer) {
        this.messageCapabilities = messageCapabilities;
        this.eventBus = eventBus;
        this.mailbox = mailbox;
        this.mapperFactory = mapperFactory;
        this.index = index;
        this.locker = locker;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.batchSizes = batchSizes;
        this.storeRightManager = storeRightManager;
        this.preDeletionHooks = preDeletionHooks;
        this.messageStorer = messageStorer;
    }

    public Mailbox getMailboxEntity() {
        return this.mailbox;
    }

    public Flags getPermanentFlags(MailboxSession session) {
        return new Flags(MINIMAL_PERMANET_FLAGS);
    }

    public MailboxCounters getMailboxCounters(MailboxSession mailboxSession) throws MailboxException {
        if (this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return this.mapperFactory.createMessageMapper(mailboxSession).getMailboxCounters(this.mailbox);
        }
        return MailboxCounters.empty((MailboxId)this.mailbox.getMailboxId());
    }

    public Publisher<MailboxCounters> getMailboxCountersReactive(MailboxSession mailboxSession) {
        if (this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return this.mapperFactory.createMessageMapper(mailboxSession).getMailboxCountersReactive(this.mailbox);
        }
        return Mono.just((Object)MailboxCounters.empty((MailboxId)this.mailbox.getMailboxId()));
    }

    protected Flags getSharedPermanentFlags(MailboxSession session) {
        return this.getPermanentFlags(session);
    }

    public Iterator<MessageUid> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        List<MessageUid> uids = MailboxReactorUtils.block(this.retrieveMessagesMarkedForDeletion(set, mailboxSession));
        Map<MessageUid, MessageMetaData> deletedMessages = MailboxReactorUtils.block(this.deleteMessages(uids, mailboxSession));
        this.dispatchExpungeEvent(mailboxSession, deletedMessages).block();
        return deletedMessages.keySet().iterator();
    }

    public Flux<MessageUid> expungeReactive(MessageRange set, MailboxSession mailboxSession) {
        if (!this.isWriteable(mailboxSession)) {
            return Flux.error((Throwable)new ReadOnlyException(this.getMailboxEntity().generateAssociatedPath()));
        }
        return this.retrieveMessagesMarkedForDeletion(set, mailboxSession).flatMap(uids -> this.deleteMessages((List<MessageUid>)uids, mailboxSession)).flatMap(deletedMessages -> this.dispatchExpungeEvent(mailboxSession, (Map<MessageUid, MessageMetaData>)deletedMessages).thenReturn(deletedMessages)).flatMapIterable(Map::keySet);
    }

    private Mono<List<MessageUid>> retrieveMessagesMarkedForDeletion(MessageRange messageRange, MailboxSession session) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.executeReactive(messageMapper.retrieveMessagesMarkedForDeletionReactive(this.getMailboxEntity(), messageRange).collectList());
    }

    public void delete(List<MessageUid> messageUids, MailboxSession mailboxSession) throws MailboxException {
        Map<MessageUid, MessageMetaData> deletedMessages = MailboxReactorUtils.block(this.deleteMessages(messageUids, mailboxSession));
        this.dispatchExpungeEvent(mailboxSession, deletedMessages).block();
    }

    public Mono<Void> deleteReactive(List<MessageUid> uids, MailboxSession mailboxSession) {
        return this.deleteMessages(uids, mailboxSession).flatMap(deleteMessages -> this.dispatchExpungeEvent(mailboxSession, (Map<MessageUid, MessageMetaData>)deleteMessages));
    }

    private Mono<Map<MessageUid, MessageMetaData>> deleteMessages(List<MessageUid> messageUids, MailboxSession session) {
        if (messageUids.isEmpty()) {
            return Mono.just((Object)ImmutableMap.of());
        }
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return this.runPredeletionHooks(messageUids, session).then(messageMapper.executeReactive(messageMapper.deleteMessagesReactive(this.getMailboxEntity(), messageUids)));
    }

    private Mono<Void> dispatchExpungeEvent(MailboxSession mailboxSession, Map<MessageUid, MessageMetaData> deletedMessages) {
        return this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).metaData((SortedMap<MessageUid, MessageMetaData>)ImmutableSortedMap.copyOf(deletedMessages))).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId()));
    }

    public MessageManager.AppendResult appendMessage(MessageManager.AppendCommand appendCommand, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.appendMessage(appendCommand.getMsgIn(), appendCommand.getInternalDate(), session, appendCommand.isRecent(), appendCommand.getFlags(), appendCommand.getMaybeParsedMessage(), appendCommand.isDelivery()));
    }

    public Publisher<MessageManager.AppendResult> appendMessageReactive(MessageManager.AppendCommand appendCommand, MailboxSession session) {
        return this.appendMessage(appendCommand.getMsgIn(), appendCommand.getInternalDate(), session, appendCommand.isRecent(), appendCommand.getFlags(), appendCommand.getMaybeParsedMessage(), appendCommand.isDelivery());
    }

    /*
     * Exception decompiling
     */
    public MessageManager.AppendResult appendMessage(InputStream msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) throws MailboxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Mono<MessageManager.AppendResult> appendMessage(Content msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet, Optional<org.apache.james.mime4j.dom.Message> maybeMessage, boolean isDelivery) {
        return Mono.fromCallable(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).flatMap(Function.identity()).subscribeOn(Schedulers.boundedElastic());
    }

    private Pair<PropertyBuilder, HeaderImpl> parseProperties(BodyOffsetInputStream bIn) throws IOException, MimeException {
        MimeTokenStream parser = this.getParser(bIn);
        HeaderImpl headers = this.readHeader(parser);
        MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
        MediaType mediaType = this.getMediaType(descriptor);
        PropertyBuilder propertyBuilder = this.getPropertyBuilder(descriptor, mediaType.mediaType, mediaType.subType);
        this.setTextualLinesCount(parser, mediaType.mediaType, propertyBuilder);
        return new ImmutablePair((Object)propertyBuilder, (Object)headers);
    }

    private Date computeInternalDate(Date internalDate) {
        return Optional.ofNullable(internalDate).orElseGet(Date::new);
    }

    private MimeTokenStream getParser(BodyOffsetInputStream bIn) {
        MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder(null, (FieldParser)FIELD_PARSER, DecodeMonitor.SILENT));
        parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
        parser.parse((InputStream)bIn);
        return parser;
    }

    private MediaType getMediaType(MaximalBodyDescriptor descriptor) {
        String mediaTypeFromHeader = descriptor.getMediaType();
        if (mediaTypeFromHeader == null) {
            return new MediaType("text", "plain");
        }
        return new MediaType(mediaTypeFromHeader, descriptor.getSubType());
    }

    private HeaderImpl readHeader(MimeTokenStream parser) throws IOException, MimeException {
        HeaderImpl header = new HeaderImpl();
        EntityState next = parser.next();
        while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
            if (next == EntityState.T_FIELD) {
                header.addField(parser.getField());
            }
            next = parser.next();
        }
        return header;
    }

    private Flags getFlags(MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) {
        Flags flags;
        if (flagsToBeSet == null) {
            flags = new Flags();
        } else {
            flags = flagsToBeSet;
            this.trimFlags(flags, mailboxSession);
        }
        if (isRecent) {
            flags.add(Flags.Flag.RECENT);
        }
        return flags;
    }

    private void setTextualLinesCount(MimeTokenStream parser, String mediaType, PropertyBuilder propertyBuilder) throws IOException, MimeException {
        if ("text".equalsIgnoreCase(mediaType)) {
            CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
            bodyStream.readAll();
            long lines = bodyStream.getLineCount();
            bodyStream.close();
            EntityState next = parser.next();
            if (next == EntityState.T_EPILOGUE) {
                CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                epilogueStream.readAll();
                lines += (long)epilogueStream.getLineCount();
                epilogueStream.close();
            }
            propertyBuilder.setTextualLineCount(lines);
        }
    }

    private int getBodyStartOctet(BodyOffsetInputStream bIn) {
        int bodyStartOctet = (int)bIn.getBodyStartOffset();
        if (bodyStartOctet == -1) {
            bodyStartOctet = 0;
        }
        return bodyStartOctet;
    }

    private Mono<MessageManager.AppendResult> createAndDispatchMessage(Date internalDate, MailboxSession mailboxSession, Content content, PropertyBuilder propertyBuilder, Flags flags, int bodyStartOctet, Optional<org.apache.james.mime4j.dom.Message> maybeMessage, HeaderImpl headers, boolean isDelivery) throws MailboxException {
        int size = (int)content.size();
        QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(this.mailbox);
        return Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).map(quotas -> new QuotaChecker((QuotaManager.Quotas)quotas, quotaRoot)).doOnNext(Throwing.consumer(quotaChecker -> quotaChecker.tryAddition(1L, size)).sneakyThrow()).then(Mono.from((Publisher)this.locker.executeReactiveWithLockReactive(this.getMailboxPath(), (Publisher)this.messageStorer.appendMessageToStore(this.mailbox, internalDate, size, bodyStartOctet, content, flags, propertyBuilder, maybeMessage, mailboxSession, headers).flatMap(data -> this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireIsDelivery)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.mailbox)).addMetaData((MessageMetaData)data.getLeft())).isDelivery(isDelivery)).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())).thenReturn((Object)this.computeAppendResult((Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>>)data, this.mailbox))), MailboxPathLocker.LockType.Write)));
    }

    private MessageManager.AppendResult computeAppendResult(Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>> data, Mailbox mailbox) {
        MessageMetaData messageMetaData = (MessageMetaData)data.getLeft();
        ComposedMessageId ids = new ComposedMessageId(mailbox.getMailboxId(), messageMetaData.getMessageId(), messageMetaData.getUid());
        return new MessageManager.AppendResult(ids, Long.valueOf(messageMetaData.getSize()), (Optional)data.getRight(), messageMetaData.getThreadId());
    }

    private PropertyBuilder getPropertyBuilder(MaximalBodyDescriptor descriptor, String mediaType, String subType) {
        PropertyBuilder propertyBuilder = new PropertyBuilder();
        propertyBuilder.setMediaType(mediaType);
        propertyBuilder.setSubType(subType);
        propertyBuilder.setContentID(descriptor.getContentId());
        propertyBuilder.setContentDescription(descriptor.getContentDescription());
        propertyBuilder.setContentLocation(descriptor.getContentLocation());
        propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
        propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
        propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
        propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
        propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
        propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
        String codeset = descriptor.getCharset();
        if (codeset == null) {
            if ("TEXT".equalsIgnoreCase(mediaType)) {
                propertyBuilder.setCharset("us-ascii");
            }
        } else {
            propertyBuilder.setCharset(codeset);
        }
        return propertyBuilder;
    }

    public boolean isWriteable(MailboxSession session) {
        return this.storeRightManager.isReadWrite(session, this.mailbox, this.getSharedPermanentFlags(session));
    }

    public Mono<MessageManager.MailboxMetaData> getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession, EnumSet<MessageManager.MailboxMetaData.Item> items) throws MailboxException {
        MailboxACL resolvedAcl = this.getResolvedAcl(mailboxSession);
        if (!this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return Mono.just((Object)MessageManager.MailboxMetaData.sensibleInformationFree((MailboxACL)resolvedAcl, (UidValidity)this.getMailboxEntity().getUidValidity(), (boolean)this.isWriteable(mailboxSession)));
        }
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        UidValidity uidValidity = this.getMailboxEntity().getUidValidity();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.executeReactive(Mono.zip(this.nextUid(messageMapper, items), this.highestModSeq(messageMapper, items), this.firstUnseen(messageMapper, items), this.mailboxCounters(messageMapper, items), this.recent(recentMode, mailboxSession)).map(t5 -> new MessageManager.MailboxMetaData((List)t5.getT5(), permanentFlags, uidValidity, (MessageUid)t5.getT1(), (ModSeq)t5.getT2(), ((MailboxCounters)t5.getT4()).getCount(), ((MailboxCounters)t5.getT4()).getUnseen(), (MessageUid)((Optional)t5.getT3()).orElse(null), this.isWriteable(mailboxSession), resolvedAcl)));
    }

    private Mono<ModSeq> highestModSeq(MessageMapper messageMapper, EnumSet<MessageManager.MailboxMetaData.Item> items) {
        if (items.contains(MessageManager.MailboxMetaData.Item.HighestModSeq)) {
            return messageMapper.getHighestModSeqReactive(this.mailbox);
        }
        return Mono.just((Object)ModSeq.first());
    }

    private Mono<MessageUid> nextUid(MessageMapper messageMapper, EnumSet<MessageManager.MailboxMetaData.Item> items) {
        if (items.contains(MessageManager.MailboxMetaData.Item.NextUid)) {
            return messageMapper.getLastUidReactive(this.mailbox).map(optional -> optional.map(MessageUid::next).orElse(MessageUid.MIN_VALUE));
        }
        return Mono.just((Object)MessageUid.MIN_VALUE);
    }

    private Mono<Optional<MessageUid>> firstUnseen(MessageMapper messageMapper, EnumSet<MessageManager.MailboxMetaData.Item> items) {
        if (items.contains(MessageManager.MailboxMetaData.Item.FirstUnseen)) {
            return messageMapper.findFirstUnseenMessageUidReactive(this.getMailboxEntity());
        }
        return Mono.just(Optional.empty());
    }

    private Mono<MailboxCounters> mailboxCounters(MessageMapper messageMapper, EnumSet<MessageManager.MailboxMetaData.Item> items) {
        if (items.contains(MessageManager.MailboxMetaData.Item.MailboxCounters)) {
            return messageMapper.getMailboxCountersReactive(this.getMailboxEntity());
        }
        return Mono.just((Object)MailboxCounters.empty((MailboxId)this.getId()));
    }

    public MessageManager.MailboxMetaData getMetaData(MessageManager.MailboxMetaData.RecentMode resetRecent, MailboxSession mailboxSession, EnumSet<MessageManager.MailboxMetaData.Item> items) throws MailboxException {
        return MailboxReactorUtils.block(this.getMetaDataReactive(resetRecent, mailboxSession, items));
    }

    public MailboxACL getResolvedAcl(MailboxSession mailboxSession) throws UnsupportedRightException {
        return this.storeRightManager.getResolvedMailboxACL(this.mailbox, mailboxSession);
    }

    private void trimFlags(Flags flags, MailboxSession session) {
        Flags.Flag[] systemFlags;
        Flags permFlags = this.getPermanentFlags(session);
        for (Flags.Flag f : systemFlags = flags.getSystemFlags()) {
            if (f == Flags.Flag.RECENT || permFlags.contains(f)) continue;
            flags.remove(f);
        }
        if (!permFlags.contains(Flags.Flag.USER)) {
            String[] uFlags;
            for (String uFlag : uFlags = flags.getUserFlags()) {
                if (permFlags.contains(uFlag)) continue;
                flags.remove(uFlag);
            }
        }
    }

    public Map<MessageUid, Flags> setFlags(Flags flags, MessageManager.FlagsUpdateMode flagsUpdateMode, MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        this.trimFlags(flags, mailboxSession);
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Iterator it = messageMapper.execute(() -> messageMapper.updateFlags(this.getMailboxEntity(), new FlagsUpdateCalculator(flags, flagsUpdateMode), set));
        List updatedFlags = (List)Iterators.toStream((Iterator)it).collect(ImmutableList.toImmutableList());
        this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).updatedFlags(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())).block();
        return (Map)updatedFlags.stream().collect(ImmutableMap.toImmutableMap(UpdatedFlags::getUid, UpdatedFlags::getNewFlags));
    }

    public Publisher<Map<MessageUid, Flags>> setFlagsReactive(Flags flags, MessageManager.FlagsUpdateMode flagsUpdateMode, MessageRange set, MailboxSession mailboxSession) {
        if (!this.isWriteable(mailboxSession)) {
            return Mono.error((Throwable)new ReadOnlyException(this.getMailboxPath()));
        }
        this.trimFlags(flags, mailboxSession);
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.executeReactive(messageMapper.updateFlagsReactive(this.getMailboxEntity(), new FlagsUpdateCalculator(flags, flagsUpdateMode), set)).flatMap(updatedFlags -> this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).updatedFlags((Iterable<UpdatedFlags>)updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())).thenReturn((Object)((ImmutableMap)updatedFlags.stream().collect(ImmutableMap.toImmutableMap(UpdatedFlags::getUid, UpdatedFlags::getNewFlags)))));
    }

    public Mono<List<MessageRange>> copyTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) {
        if (!toMailbox.isWriteable(session)) {
            return Mono.error((Throwable)new ReadOnlyException(toMailbox.getMailboxPath()));
        }
        return Mono.from((Publisher)this.locker.executeReactiveWithLockReactive(toMailbox.getMailboxPath(), (Publisher)this.copy(set, toMailbox, session).map(map -> MessageRange.toRanges(new ArrayList(map.keySet()))), MailboxPathLocker.LockType.Write));
    }

    public Mono<List<MessageRange>> moveTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) {
        if (!this.isWriteable(session)) {
            return Mono.error((Throwable)new ReadOnlyException(toMailbox.getMailboxPath()));
        }
        if (!toMailbox.isWriteable(session)) {
            return Mono.error((Throwable)new ReadOnlyException(toMailbox.getMailboxPath()));
        }
        return Mono.from((Publisher)this.locker.executeReactiveWithLockReactive(toMailbox.getMailboxPath(), (Publisher)this.move(set, toMailbox, session).map(map -> MessageRange.toRanges(new ArrayList(map.keySet()))), MailboxPathLocker.LockType.Write));
    }

    public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.getMessageMapper(mailboxSession).countMessagesInMailbox(this.getMailboxEntity());
    }

    public MessageResultIterator getMessages(MessageRange set, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return new StoreMessageResultIterator(messageMapper, this.mailbox, set, this.batchSizes, fetchGroup);
    }

    public Publisher<MessageResult> getMessagesReactive(MessageRange set, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        return Flux.from(this.mapperFactory.getMessageMapper(mailboxSession).findInMailboxReactive(this.mailbox, set, FetchGroupConverter.getFetchType(fetchGroup), -1)).map(Throwing.function(message -> ResultUtils.loadMessageResult(message, fetchGroup)).sneakyThrow());
    }

    public Publisher<ComposedMessageIdWithMetaData> listMessagesMetadata(MessageRange set, MailboxSession session) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.listMessagesMetadata(this.mailbox, set);
    }

    private Mono<List<MessageUid>> recent(MessageManager.MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        switch (recentMode) {
            case IGNORE: {
                return Mono.just((Object)ImmutableList.of());
            }
            case RETRIEVE: {
                return messageMapper.findRecentMessageUidsInMailboxReactive(this.getMailboxEntity());
            }
            case RESET: {
                return this.resetRecents(messageMapper, mailboxSession);
            }
        }
        throw new RuntimeException("Unsupported recent mode " + recentMode);
    }

    private Mono<List<MessageUid>> resetRecents(MessageMapper messageMapper, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath());
        }
        return messageMapper.resetRecentReactive(this.getMailboxEntity()).flatMap(updatedFlags -> this.publishResentFlagsUpdateIfNeeded(mailboxSession, (List<UpdatedFlags>)updatedFlags).thenReturn((Object)((ImmutableList)updatedFlags.stream().map(UpdatedFlags::getUid).collect(ImmutableList.toImmutableList()))));
    }

    private Mono<Void> publishResentFlagsUpdateIfNeeded(MailboxSession mailboxSession, List<UpdatedFlags> updatedFlags) {
        if (!updatedFlags.isEmpty()) {
            return this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(this.getMailboxEntity())).updatedFlags(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId()));
        }
        return Mono.empty();
    }

    private Mono<Void> runPredeletionHooks(List<MessageUid> uids, MailboxSession session) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        Mono deleteOperation = Flux.fromIterable((Iterable)MessageRange.toRanges(uids)).flatMap(range -> messageMapper.findInMailboxReactive(this.mailbox, (MessageRange)range, MessageMapper.FetchType.METADATA, -1), 16).map(mailboxMessage -> MetadataWithMailboxId.from((MessageMetaData)mailboxMessage.metaData(), (MailboxId)mailboxMessage.getMailboxId())).collect(ImmutableList.toImmutableList()).map(PreDeletionHook.DeleteOperation::from);
        return deleteOperation.flatMap(this.preDeletionHooks::runHooks).then();
    }

    public Flux<MessageUid> search(SearchQuery query, MailboxSession mailboxSession) throws MailboxException {
        if (query.equals((Object)LIST_ALL_QUERY) || query.equals((Object)LIST_FROM_ONE)) {
            return this.listAllMessageUids(mailboxSession);
        }
        return this.index.search(mailboxSession, this.getMailboxEntity(), query);
    }

    private Flux<MessageMetaData> copy(List<MailboxMessage> originalRows, MailboxSession session) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        try {
            QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(this.getMailboxPath());
            return Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).doOnNext(Throwing.consumer(quotas -> new QuotaChecker((QuotaManager.Quotas)quotas, quotaRoot).tryAddition(originalRows.size(), originalRows.stream().mapToLong(Message::getFullContentOctets).sum())).sneakyThrow()).thenMany((Publisher)messageMapper.executeReactive(messageMapper.copyReactive(this.getMailboxEntity(), originalRows)).flatMapIterable(Function.identity()));
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    private Mono<MoveResult> move(List<MailboxMessage> originalRows, MailboxSession session) {
        List originalRowsCopy = (List)originalRows.stream().map(MailboxMessage::metaData).collect(ImmutableList.toImmutableList());
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.executeReactive(messageMapper.moveReactive(this.getMailboxEntity(), originalRows)).map(data -> new MoveResult((List<MessageMetaData>)data, originalRowsCopy));
    }

    private Mono<SortedMap<MessageUid, MessageMetaData>> copy(MessageRange set, StoreMessageManager to, MailboxSession session) {
        return this.retrieveOriginalRows(set, session).collectList().flatMap(originalRows -> to.copy((List<MailboxMessage>)originalRows, session).collectList().flatMap(copyResult -> {
            SortedMap<MessageUid, MessageMetaData> copiedUids = this.collectMetadata(copyResult.iterator());
            ImmutableList messageIds = (ImmutableList)originalRows.stream().map(Message::getMessageId).collect(ImmutableList.toImmutableList());
            MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId(), this.getMailboxEntity().getMailboxId()}).build();
            return Flux.concat((Publisher[])new Publisher[]{this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireIsDelivery)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(session)).mailbox(to.getMailboxEntity())).metaData(copiedUids)).isDelivery(!MailboxEvents.Added.IS_DELIVERY)).build(), (RegistrationKey)new MailboxIdRegistrationKey(to.getMailboxEntity().getMailboxId())), this.eventBus.dispatch((Event)EventFactory.moved().messageMoves(messageMoves).messageId((Iterable)messageIds).session(session).build(), (Set)messageMoves.impactedMailboxIds().map(MailboxIdRegistrationKey::new).collect(ImmutableSet.toImmutableSet()))}).then().thenReturn(copiedUids);
        }));
    }

    private Mono<SortedMap<MessageUid, MessageMetaData>> move(MessageRange set, StoreMessageManager to, MailboxSession session) {
        return this.retrieveOriginalRows(set, session).collectList().flatMap(originalRows -> to.move((List<MailboxMessage>)originalRows, session).flatMap(moveResult -> {
            SortedMap<MessageUid, MessageMetaData> moveUids = this.collectMetadata(moveResult.getMovedMessages().iterator());
            ImmutableList messageIds = (ImmutableList)originalRows.stream().map(Message::getMessageId).collect(ImmutableList.toImmutableList());
            MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId()}).build();
            return Flux.concat((Publisher[])new Publisher[]{this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireIsDelivery)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(session)).mailbox(to.getMailboxEntity())).metaData(moveUids)).isDelivery(!MailboxEvents.Added.IS_DELIVERY)).build(), (RegistrationKey)new MailboxIdRegistrationKey(to.getMailboxEntity().getMailboxId())), this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(session)).mailbox(this.getMailboxEntity())).addMetaData(moveResult.getOriginalMessages())).build(), (RegistrationKey)new MailboxIdRegistrationKey(this.mailbox.getMailboxId())), this.eventBus.dispatch((Event)EventFactory.moved().messageMoves(messageMoves).messageId((Iterable)messageIds).session(session).build(), (Set)messageMoves.impactedMailboxIds().map(MailboxIdRegistrationKey::new).collect(ImmutableSet.toImmutableSet()))}).then().thenReturn(moveUids);
        }));
    }

    private Flux<MailboxMessage> retrieveOriginalRows(MessageRange set, MailboxSession session) {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findInMailboxReactive(this.mailbox, set, MessageMapper.FetchType.METADATA, -1);
    }

    private SortedMap<MessageUid, MessageMetaData> collectMetadata(Iterator<MessageMetaData> ids) {
        TreeMap<MessageUid, MessageMetaData> copiedMessages = new TreeMap<MessageUid, MessageMetaData>();
        while (ids.hasNext()) {
            MessageMetaData data = ids.next();
            copiedMessages.put(data.getUid(), data);
        }
        return copiedMessages;
    }

    public MailboxId getId() {
        return this.mailbox.getMailboxId();
    }

    public MailboxPath getMailboxPath() {
        return this.getMailboxEntity().generateAssociatedPath();
    }

    public Flags getApplicableFlags(MailboxSession session) throws MailboxException {
        return this.mapperFactory.getMessageMapper(session).getApplicableFlag(this.mailbox);
    }

    public Mono<Flags> getApplicableFlagsReactive(MailboxSession session) {
        return this.mapperFactory.getMessageMapper(session).getApplicableFlagReactive(this.mailbox);
    }

    private Flux<MessageUid> listAllMessageUids(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(() -> messageMapper.listAllMessageUids(this.mailbox));
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return this.messageCapabilities;
    }

    static {
        LIST_ALL_QUERY = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()});
        LIST_FROM_ONE = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(MessageUid.MIN_VALUE, MessageUid.MAX_VALUE)})});
        FIELD_PARSER = new LenientFieldParser();
        MINIMAL_PERMANET_FLAGS = new Flags();
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.ANSWERED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DELETED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DRAFT);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.FLAGGED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.SEEN);
    }

    private static class MediaType {
        final String mediaType;
        final String subType;

        private MediaType(String mediaType, String subType) {
            this.mediaType = mediaType;
            this.subType = subType;
        }
    }
}

