/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LsubRequest;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSubProcessor
extends AbstractSubscriptionProcessor<LsubRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LSubProcessor.class);

    public LSubProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(LsubRequest.class, next, mailboxManager, subscriptionManager, factory, metricFactory);
    }

    @Override
    protected void doProcessRequest(LsubRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String referenceName = request.getBaseReferenceName();
        String mailboxPattern = request.getMailboxPattern();
        try {
            this.listSubscriptions(session, responder, referenceName, mailboxPattern);
            this.okComplete(request, responder);
        }
        catch (MailboxException e) {
            LOGGER.error("LSub failed for reference {} and pattern {}", new Object[]{referenceName, mailboxPattern, e});
            this.no(request, responder, HumanReadableText.GENERIC_LSUB_FAILURE);
        }
    }

    private void listSubscriptions(ImapSession session, ImapProcessor.Responder responder, String referenceName, String mailboxName) throws SubscriptionException, MailboxException {
        MailboxSession mailboxSession = session.getMailboxSession();
        Collection mailboxes = this.getSubscriptionManager().subscriptions(mailboxSession);
        String decodedMailName = ModifiedUtf7.decodeModifiedUTF7(referenceName);
        PrefixedRegex expression = new PrefixedRegex(decodedMailName, ModifiedUtf7.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter());
        ArrayList<String> mailboxResponses = new ArrayList<String>();
        for (String mailbox : mailboxes) {
            this.respond(responder, (MailboxNameExpression)expression, mailbox, true, mailboxes, mailboxResponses, mailboxSession.getPathDelimiter());
        }
    }

    private void respond(ImapProcessor.Responder responder, MailboxNameExpression expression, String mailboxName, boolean originalSubscription, Collection<String> mailboxes, Collection<String> mailboxResponses, char delimiter) {
        if (expression.isExpressionMatch(mailboxName)) {
            if (!mailboxResponses.contains(mailboxName)) {
                responder.respond(new LSubResponse(mailboxName, !originalSubscription, delimiter));
                mailboxResponses.add(mailboxName);
            }
        } else {
            String parentMailbox;
            int lastDelimiter = mailboxName.lastIndexOf(delimiter);
            if (lastDelimiter > 0 && !mailboxes.contains(parentMailbox = mailboxName.substring(0, lastDelimiter))) {
                this.respond(responder, expression, parentMailbox, false, mailboxes, mailboxResponses, delimiter);
            }
        }
    }

    @Override
    protected Closeable addContextToMDC(LsubRequest request) {
        return MDCBuilder.create().addToContext("action", "LSUB").addToContext("base", request.getBaseReferenceName()).addToContext("pattern", request.getMailboxPattern()).build();
    }
}

