/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.protocols.PingData;
import org.jgroups.util.CondVar;
import org.jgroups.util.Condition;

public class Responses
implements Iterable<PingData>,
Condition {
    protected PingData[] ping_rsps;
    protected int index;
    protected final Lock lock = new ReentrantLock();
    protected final CondVar cond = new CondVar(this.lock);
    protected final int num_expected_rsps;
    protected final boolean break_on_coord_rsp;
    protected boolean done = false;

    public Responses(boolean break_on_coord_rsp) {
        this(0, break_on_coord_rsp);
    }

    public Responses(int num_expected_rsps, boolean break_on_coord_rsp) {
        this(num_expected_rsps, break_on_coord_rsp, 16);
    }

    public Responses(int num_expected_rsps, boolean break_on_coord_rsp, int initial_capacity) {
        this.num_expected_rsps = num_expected_rsps;
        this.break_on_coord_rsp = break_on_coord_rsp;
        this.ping_rsps = new PingData[Math.max(5, initial_capacity)];
    }

    @Override
    public boolean isMet() {
        return this.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responses done() {
        this.lock.lock();
        try {
            Responses responses = this._done();
            return responses;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responses clear() {
        this.lock.lock();
        try {
            this.index = 0;
            Responses responses = this._done();
            return responses;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(PingData rsp, boolean overwrite) {
        if (rsp == null) {
            return;
        }
        boolean is_coord_rsp = rsp.isCoord();
        boolean changed = false;
        this.lock.lock();
        try {
            int ind = this.find(rsp);
            if (ind == -1) {
                this.add(rsp);
                changed = true;
            } else {
                PingData existing = this.ping_rsps[ind];
                if (overwrite || is_coord_rsp && !existing.isCoord()) {
                    this.ping_rsps[ind] = rsp;
                    changed = true;
                }
            }
            if (changed && (this.num_expected_rsps > 0 && this.index >= this.num_expected_rsps || this.break_on_coord_rsp && is_coord_rsp)) {
                this._done();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean containsResponseFrom(Address mbr) {
        if (mbr == null) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.ping_rsps[i] == null || !mbr.equals(this.ping_rsps[i].getAddress())) continue;
            return true;
        }
        return false;
    }

    public PingData findResponseFrom(Address mbr) {
        if (mbr == null) {
            return null;
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.ping_rsps[i] == null || !mbr.equals(this.ping_rsps[i].getAddress())) continue;
            return this.ping_rsps[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<PingData> get(long timeout) throws InterruptedException {
        this.lock.lock();
        try {
            this.waitFor(timeout);
            List<PingData> list = this.toList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean waitFor(long timeout) {
        return this.cond.waitFor(this, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PingData> iterator() {
        this.lock.lock();
        try {
            PingDataIterator pingDataIterator = new PingDataIterator(this.ping_rsps, this.index);
            return pingDataIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.index;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        int[] num = this.numResponses();
        return String.format("%d rsps (%d coords) [%s]", num[0], num[1], this.isDone() ? "done" : "pending");
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        for (PingData data : this) {
            sb.append(data).append("\n");
        }
        return sb.toString();
    }

    protected Responses _done() {
        if (!this.done) {
            this.done = true;
            this.cond.signal(true);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] numResponses() {
        this.lock.lock();
        try {
            int[] num = new int[]{0, 0};
            for (int i = 0; i < this.index; ++i) {
                PingData data = this.ping_rsps[i];
                num[0] = num[0] + 1;
                if (!data.isCoord()) continue;
                num[1] = num[1] + 1;
            }
            int[] nArray = num;
            return nArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected List<PingData> toList() {
        ArrayList<PingData> retval = new ArrayList<PingData>();
        retval.addAll(Arrays.asList(this.ping_rsps).subList(0, this.index));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int new_size) {
        this.lock.lock();
        try {
            this.ping_rsps = Arrays.copyOf(this.ping_rsps, new_size);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void add(PingData data) {
        if (this.index >= this.ping_rsps.length) {
            this.resize(Responses.newLength(this.ping_rsps.length));
        }
        this.ping_rsps[this.index++] = data;
    }

    protected int find(PingData data) {
        if (data == null) {
            return -1;
        }
        for (int i = 0; i < this.index; ++i) {
            if (!data.equals(this.ping_rsps[i])) continue;
            return i;
        }
        return -1;
    }

    protected static int newLength(int length) {
        return length > 1000 ? (int)((double)length * 1.1) : Math.max(5, length * 2);
    }

    protected static class PingDataIterator
    implements Iterator<PingData> {
        protected final PingData[] data;
        protected final int end_index;
        protected int index;

        public PingDataIterator(PingData[] data, int end_index) {
            this.data = data;
            this.end_index = end_index;
            if (data == null) {
                throw new IllegalArgumentException("data cannot be null");
            }
            if (end_index > data.length) {
                throw new IndexOutOfBoundsException("index is " + end_index + ", but arrays's length is only " + data.length);
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.end_index && this.data[this.index] != null;
        }

        @Override
        public PingData next() {
            if (this.index >= this.end_index || this.index >= this.data.length) {
                throw new NoSuchElementException("index=" + this.index);
            }
            return this.data[this.index++];
        }

        @Override
        public void remove() {
        }
    }
}

