/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.IOException;
import java.io.Serializable;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.store.Store;

public final class StoreIncludeCacheStorageProxy
extends AbstractLogEnabled
implements IncludeCacheStorageProxy {
    private Store store;

    public StoreIncludeCacheStorageProxy(Store store) {
        this.store = store;
    }

    private String getKey(String uri) {
        return "DCS:" + uri;
    }

    public Serializable get(String uri) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("StoreProxy: Getting content for " + uri));
        }
        Serializable result = (Serializable)this.store.get((Object)this.getKey(uri));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("StoreProxy: Result for " + uri + " : " + (result == null ? "Not in cache" : "Found")));
        }
        return result;
    }

    public void put(String uri, Serializable object) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("StoreProxy: Storing content for " + uri));
        }
        this.store.store((Object)this.getKey(uri), (Object)object);
    }

    public void remove(String uri) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("StoreProxy: Removing content for " + uri));
        }
        this.store.remove((Object)this.getKey(uri));
    }
}

