/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.servlet.RequestUtil;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.BeanCreationException;

public class SitemapServlet
extends HttpServlet {
    private static final String PARAM_SITEMAP_PATH = "sitemap-path";
    private static final String DEFAULT_SITEMAP_PATH = "/sitemap.xmap";
    private static final String PARAM_CHECK_RELOAD = "check-reload";
    private static final String PARAM_PASS_THROUGH = "pass-through";
    protected RequestProcessor processor;

    public void init() throws ServletException {
        super.init();
        this.processor = new RequestProcessor(this.getServletContext());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processor.service(request, response);
    }

    public void destroy() {
        if (this.processor != null) {
            this.processor.destroy();
        }
        super.destroy();
    }

    protected class RequestProcessor
    extends org.apache.cocoon.servlet.RequestProcessor {
        public RequestProcessor(ServletContext servletContext) {
            super(servletContext);
        }

        protected boolean rethrowExceptions() {
            return true;
        }

        protected Processor getProcessor() {
            TreeProcessor processor;
            Configuration config;
            try {
                config = this.createTreeProcessorConfiguration(this.servletContext);
            }
            catch (IOException e) {
                throw new BeanCreationException("Could not create configuration for TreeProcesoor", (Throwable)e);
            }
            ServiceManager serviceManager = (ServiceManager)this.cocoonBeanFactory.getBean("org.apache.avalon.framework.service.ServiceManager");
            try {
                processor = new TreeProcessor();
                ContainerUtil.service((Object)processor, (ServiceManager)serviceManager);
                ContainerUtil.configure((Object)processor, (Configuration)config);
                ContainerUtil.initialize((Object)processor);
            }
            catch (Exception e) {
                throw new BeanCreationException("Could not create TreeProcessor", (Throwable)e);
            }
            return processor;
        }

        protected void destroy() {
            if (this.processor != null) {
                ContainerUtil.dispose((Object)this.processor);
                this.processor = null;
            }
        }

        protected String getURI(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return RequestUtil.getCompleteBlockUri(request, response);
        }

        private Configuration createTreeProcessorConfiguration(ServletContext servletContext) throws IOException {
            String passThroughStr;
            URL uri;
            String sitemapPath = SitemapServlet.this.getInitParameter(SitemapServlet.PARAM_SITEMAP_PATH);
            if (sitemapPath == null) {
                sitemapPath = SitemapServlet.DEFAULT_SITEMAP_PATH;
            }
            if ((uri = servletContext.getResource(sitemapPath)) == null) {
                throw new IOException("Couldn't find the sitemap " + sitemapPath);
            }
            String sitemapURI = uri.toExternalForm();
            DefaultConfiguration config = new DefaultConfiguration("sitemap");
            config.setAttribute("file", sitemapURI);
            String checkReloadStr = SitemapServlet.this.getInitParameter(SitemapServlet.PARAM_CHECK_RELOAD);
            if (checkReloadStr != null) {
                boolean checkReload = BooleanUtils.toBoolean((String)checkReloadStr);
                config.setAttribute(SitemapServlet.PARAM_CHECK_RELOAD, checkReload);
            }
            if ((passThroughStr = SitemapServlet.this.getInitParameter(SitemapServlet.PARAM_PASS_THROUGH)) != null) {
                boolean passThrough = BooleanUtils.toBoolean((String)passThroughStr);
                config.setAttribute(SitemapServlet.PARAM_PASS_THROUGH, passThrough);
            }
            return config;
        }
    }
}

