/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.Constants;
import org.apache.cocoon.Processor;
import org.apache.cocoon.RequestListener;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.logger.LoggerUtils;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.servlet.RequestUtil;
import org.apache.cocoon.servlet.ServletSettings;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RequestProcessor
extends AbstractLogEnabled {
    protected static final String PROCESSED_BY = "Processed by Apache Cocoon in ";
    static final float SECOND = 1000.0f;
    static final float MINUTE = 60000.0f;
    static final float HOUR = 3600000.0f;
    protected final ServletContext servletContext;
    protected final Context environmentContext;
    protected final String containerEncoding;
    protected final BeanFactory cocoonBeanFactory;
    protected final Settings settings;
    protected final ServletSettings servletSettings;
    protected Processor processor;
    protected RequestListener requestListener;

    public RequestProcessor(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.cocoonBeanFactory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.settings = (Settings)this.cocoonBeanFactory.getBean(Settings.ROLE);
        this.servletSettings = new ServletSettings(this.settings);
        String encoding = this.settings.getContainerEncoding();
        this.containerEncoding = encoding == null ? "ISO-8859-1" : encoding;
        String category = servletContext.getInitParameter("org.apache.cocoon.servlet.logger.access");
        if (category == null || category.length() == 0) {
            category = "access";
        }
        this.setLogger(LoggerUtils.getChildLogger((BeanFactory)this.cocoonBeanFactory, (String)category));
        this.processor = this.getProcessor();
        this.environmentContext = new HttpContext(this.servletContext);
        if (this.cocoonBeanFactory.containsBean(RequestListener.ROLE)) {
            this.requestListener = (RequestListener)this.cocoonBeanFactory.getBean(RequestListener.ROLE);
        }
    }

    protected Processor getProcessor() {
        return (Processor)this.cocoonBeanFactory.getBean(Processor.ROLE);
    }

    protected boolean rethrowExceptions() {
        return false;
    }

    public void service(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
        Environment env;
        String uri;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (this.servletSettings.isShowVersion()) {
            res.addHeader("X-Cocoon-Version", Constants.VERSION);
        }
        if ((uri = this.getURI(request, res)) == null) {
            return;
        }
        try {
            env = this.getEnvironment(uri, request, res);
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error((Object)"Problem with Cocoon servlet", (Throwable)e);
            }
            if (this.rethrowExceptions()) {
                throw new ServletException((Throwable)e);
            }
            RequestUtil.manageException(request, res, null, uri, 500, "Problem in creating the Environment", null, null, e, this.servletSettings, this.getLogger(), (Object)this);
            return;
        }
        String contentType = null;
        try {
            if (!this.process(env)) {
                this.getLogger().fatal((Object)"The Cocoon engine failed to process the request.");
                if (this.rethrowExceptions()) {
                    throw new ServletException("The Cocoon engine failed to process the request.");
                }
                RequestUtil.manageException(request, res, env, uri, 500, "Request Processing Failed", "Cocoon engine failed in processing the request", "The processing engine failed to process the request. This could be due to lack of matching or bugs in the pipeline engine.", null, this.servletSettings, this.getLogger(), (Object)this);
                return;
            }
            contentType = env.getContentType();
        }
        catch (ResourceNotFoundException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)e.getMessage());
            }
            if (this.rethrowExceptions()) {
                throw new ServletException((Throwable)e);
            }
            RequestUtil.manageException(request, res, env, uri, 404, "Resource Not Found", "Resource Not Found", "The requested resource \"" + request.getRequestURI() + "\" could not be found", (Exception)((Object)e), this.servletSettings, this.getLogger(), (Object)this);
            return;
        }
        catch (ConnectionResetException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)e.toString(), (Throwable)e);
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)e.toString());
            }
        }
        catch (IOException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)e.toString(), (Throwable)e);
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)e.toString());
            }
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error((Object)"Internal Cocoon Problem", (Throwable)e);
            }
            if (this.rethrowExceptions()) {
                throw new ServletException((Throwable)e);
            }
            RequestUtil.manageException(request, res, env, uri, 500, "Internal Server Error", null, null, e, this.servletSettings, this.getLogger(), (Object)this);
            return;
        }
        stopWatch.stop();
        String timeString = null;
        if (this.getLogger().isInfoEnabled()) {
            timeString = this.processTime(stopWatch.getTime());
            this.getLogger().info((Object)("'" + uri + "' " + timeString));
        }
        if (contentType != null && contentType.equals("text/html")) {
            String showTime = request.getParameter("cocoon-showtime");
            boolean show = this.servletSettings.isShowTime();
            if (showTime != null) {
                boolean bl = show = !showTime.equalsIgnoreCase("no");
            }
            if (show) {
                if (timeString == null) {
                    timeString = this.processTime(stopWatch.getTime());
                }
                boolean hide = this.servletSettings.isHideShowTime();
                if (showTime != null) {
                    hide = showTime.equalsIgnoreCase("hide");
                }
                ServletOutputStream out = res.getOutputStream();
                out.print(hide ? "<!-- " : "<p>");
                out.print(timeString);
                out.println(hide ? " -->" : "</p>");
            }
        }
    }

    protected String getURI(HttpServletRequest request, HttpServletResponse res) throws IOException {
        return RequestUtil.getCompleteUri(request, res);
    }

    protected Environment getEnvironment(String uri, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String formEncoding = req.getParameter("cocoon-form-encoding");
        if (formEncoding == null) {
            formEncoding = this.settings.getFormEncoding();
        }
        HttpEnvironment env = new HttpEnvironment(uri, req, res, this.servletContext, this.environmentContext, this.containerEncoding, formEncoding);
        return env;
    }

    private String processTime(long time) {
        StringBuffer out = new StringBuffer(PROCESSED_BY);
        if ((float)time <= 1000.0f) {
            out.append(time);
            out.append(" milliseconds.");
        } else if ((float)time <= 60000.0f) {
            out.append((float)time / 1000.0f);
            out.append(" seconds.");
        } else if ((float)time <= 3600000.0f) {
            out.append((float)time / 60000.0f);
            out.append(" minutes.");
        } else {
            out.append((float)time / 3600000.0f);
            out.append(" hours.");
        }
        return out.toString();
    }

    protected boolean process(Environment environment) throws Exception {
        environment.startingProcessing();
        int environmentDepth = EnvironmentHelper.markEnvironment();
        EnvironmentHelper.enterProcessor((Processor)this.processor, (Environment)environment);
        try {
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestStart(environment);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"Error encountered monitoring request start", (Throwable)e);
                }
            }
            boolean result = this.processor.process(environment);
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestEnd(environment);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"Error encountered monitoring request end", (Throwable)e);
                }
            }
            environment.commitResponse();
            boolean e = result;
            return e;
        }
        catch (Exception any) {
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestException(environment, any);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"Error encountered monitoring request exception", (Throwable)e);
                }
            }
            environment.tryResetResponse();
            throw any;
        }
        finally {
            EnvironmentHelper.leaveProcessor();
            environment.finishingProcessing();
            EnvironmentHelper.checkEnvironment((int)environmentDepth);
        }
    }
}

