/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.BlockContextSource;
import org.apache.cocoon.spring.configurator.BlockResourcesHolder;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;

public class BlockContextSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
ThreadSafe {
    private ServiceManager serviceManager;
    private BlockResourcesHolder blockResourcesHolder;

    public void service(ServiceManager aServiceManager) throws ServiceException {
        this.serviceManager = aServiceManager;
        this.blockResourcesHolder = (BlockResourcesHolder)this.serviceManager.lookup(BlockResourcesHolder.class.getName());
    }

    public Source getSource(String location, Map parameters) throws IOException {
        Map blockContexts = this.blockResourcesHolder.getBlockContexts();
        if (location.endsWith(":/")) {
            return new BlockContextSource(location, blockContexts, this.serviceManager);
        }
        int pos = location.indexOf(":/");
        String path = location.substring(pos + 2);
        if ((pos = path.indexOf(47)) != -1) {
            String blockName = path.substring(0, pos);
            path = path.substring(pos);
            String blockContext = (String)blockContexts.get(blockName);
            if (blockContext == null) {
                throw new MalformedURLException("Unknown block name " + blockName + " in block context uri " + location);
            }
            String resolvedPath = blockContext + path;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("block context source " + location + " is resolved to " + resolvedPath));
            }
            SourceResolver resolver = null;
            try {
                resolver = (SourceResolver)this.serviceManager.lookup(SourceResolver.ROLE);
                Source source = resolver.resolveURI(resolvedPath);
                return source;
            }
            catch (ServiceException se) {
                throw new SourceException("SourceResolver is not available.", (Throwable)se);
            }
            finally {
                this.serviceManager.release((Object)resolver);
            }
        }
        throw new MalformedURLException("The block name part of a block context uri must end with a '/' in " + location);
    }

    public void release(Source source) {
    }
}

