/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.CascadingIOException;
import org.apache.commons.collections.map.HashedMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.AbstractSource;
import org.springframework.util.ClassUtils;

public class BlockContextSource
extends AbstractSource
implements TraversableSource {
    private Map blockContexts;
    private ServiceManager manager;
    private Map children;
    static /* synthetic */ Class class$org$apache$excalibur$source$TraversableSource;

    public BlockContextSource(String location, Map blockContexts, ServiceManager manager) throws MalformedURLException, IOException {
        this.setScheme(location.substring(0, location.indexOf(":/")));
        this.setSystemId(location);
        this.blockContexts = blockContexts;
        this.manager = manager;
        this.children = this.createChildren();
    }

    public boolean exists() {
        return true;
    }

    public Source getChild(String name) throws SourceException {
        Source child = (Source)this.children.get(name);
        if (child == null) {
            throw new SourceException("The block named " + name + "doesn't exist");
        }
        return child;
    }

    public Collection getChildren() throws SourceException {
        return this.children.values();
    }

    private Map createChildren() throws MalformedURLException, IOException {
        HashedMap children = new HashedMap(this.blockContexts.size() * 2 + 1);
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            Iterator i = this.blockContexts.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String blockName = (String)entry.getKey();
                String contextPath = (String)entry.getValue();
                Source child = resolver.resolveURI(contextPath);
                if (child instanceof TraversableSource) {
                    child = BlockContextSource.adjustName((TraversableSource)child, blockName);
                }
                children.put(blockName, child);
            }
            HashedMap hashedMap = children;
            return hashedMap;
        }
        catch (ServiceException se) {
            throw new CascadingIOException("SourceResolver is not available.", (Throwable)se);
        }
        finally {
            this.manager.release((Object)resolver);
        }
    }

    private static Source adjustName(final TraversableSource source, final String blockName) {
        TraversableSource adjustedSource = (TraversableSource)Proxy.newProxyInstance(source.getClass().getClassLoader(), ClassUtils.getAllInterfaces((Object)source), new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals((class$org$apache$excalibur$source$TraversableSource == null ? (class$org$apache$excalibur$source$TraversableSource = BlockContextSource.class$("org.apache.excalibur.source.TraversableSource")) : class$org$apache$excalibur$source$TraversableSource).getMethod("getName", new Class[0]))) {
                    return blockName;
                }
                return method.invoke((Object)source, args);
            }
        });
        return adjustedSource;
    }

    public String getName() {
        return ".";
    }

    public Source getParent() throws SourceException {
        return null;
    }

    public boolean isCollection() {
        return true;
    }
}

