/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.script;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.el.parsing.StringTemplateParser;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.script.InstructionFactory;
import org.apache.cocoon.template.script.Parser;
import org.apache.cocoon.template.script.ScriptManager;
import org.apache.cocoon.template.script.event.StartDocument;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class DefaultScriptManager
implements ScriptManager {
    private static final String JX_STORE_PREFIX = "jxtg:";
    private Store store;
    private InstructionFactory instructionFactory;
    private StringTemplateParser stringTemplateParser;
    private SourceResolver sourceResolver;
    private SAXParser saxParser;

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public InstructionFactory getInstructionFactory() {
        return this.instructionFactory;
    }

    public void setInstructionFactory(InstructionFactory instructionFactory) {
        this.instructionFactory = instructionFactory;
    }

    public StringTemplateParser getStringTemplateParser() {
        return this.stringTemplateParser;
    }

    public void setStringTemplateParser(StringTemplateParser stringTemplateParser) {
        this.stringTemplateParser = stringTemplateParser;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public SAXParser getSaxParser() {
        return this.saxParser;
    }

    public void setSaxParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public StartDocument resolveTemplate(String uri) throws SAXParseException, ProcessingException {
        return this.resolveTemplate(uri, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StartDocument resolveTemplate(String uri, Locator location) throws SAXParseException, ProcessingException {
        Source input = null;
        StartDocument doc = null;
        try {
            block13: {
                try {
                    input = this.sourceResolver.resolveURI(uri);
                    SourceValidity validity = null;
                    String storeUri = JX_STORE_PREFIX + input.getURI();
                    doc = (StartDocument)this.getStore().get((Object)storeUri);
                    if (doc != null) {
                        boolean recompile = false;
                        if (doc.getSourceValidity() == null) {
                            recompile = true;
                        } else {
                            int valid = doc.getSourceValidity().isValid();
                            if (valid == 0) {
                                validity = input.getValidity();
                                valid = doc.getSourceValidity().isValid(validity);
                            }
                            if (valid != 1) {
                                recompile = true;
                            }
                        }
                        if (recompile) {
                            doc = null;
                        }
                    }
                    if (doc != null) break block13;
                    Parser parser = new Parser(new ParsingContext(this.stringTemplateParser, this.instructionFactory));
                    if (validity == null) {
                        validity = input.getValidity();
                    }
                    SourceUtil.parse((SAXParser)this.saxParser, (Source)input, (ContentHandler)parser);
                    doc = parser.getStartEvent();
                    doc.setUri(input.getURI());
                    doc.setSourceValidity(validity);
                    this.getStore().store((Object)storeUri, (Object)doc);
                }
                catch (SourceException se) {
                    throw SourceUtil.handle((String)("Error during resolving of '" + uri + "'."), (SourceException)se);
                }
                catch (ProcessingException e) {
                    throw ProcessingException.throwLocated(null, (Throwable)e, (Location)LocationUtils.getLocation((Object)location));
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), location, e);
                }
            }
            Object var10_13 = null;
            if (input == null) return doc;
            this.sourceResolver.release(input);
            return doc;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (input == null) throw throwable;
            this.sourceResolver.release(input);
            throw throwable;
        }
    }
}

