/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.instruction.Parameter;
import org.apache.cocoon.template.script.event.Characters;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.IgnorableWhitespace;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.template.script.event.TextEvent;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Define
extends Instruction {
    private final String name;
    private final String namespace;
    private final String qname;
    private final Map parameters;
    private Event body;

    public Define(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        this.namespace = StringUtils.defaultString((String)attrs.getValue("targetNamespace"));
        this.name = attrs.getValue("name");
        if (this.name == null) {
            throw new SAXParseException("macro: \"name\" is required", this.getLocation(), null);
        }
        this.qname = "{" + this.namespace + "}" + this.name;
        this.parameters = new HashMap();
    }

    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        executionContext.getDefinitions().put(this.qname, this);
        return this.getEndInstruction().getNext();
    }

    public void endNotify() throws SAXException {
        boolean params = true;
        block0: for (Event e = this.next; e != this.getEndInstruction(); e = e.getNext()) {
            if (e instanceof Parameter) {
                Parameter startParam = (Parameter)e;
                if (!params) {
                    throw new SAXParseException("<parameter> not allowed here: \"" + startParam.name + "\"", startParam.getLocation(), null);
                }
                Parameter prev = this.parameters.put(startParam.name, startParam);
                if (prev != null) {
                    throw new SAXParseException("duplicate parameter: \"" + startParam.name + "\"", this.location, null);
                }
                e = startParam.getEndInstruction();
                continue;
            }
            if (e instanceof IgnorableWhitespace) continue;
            if (e instanceof Characters) {
                char[] ch = ((TextEvent)e).getRaw();
                int len = ch.length;
                for (int i = 0; i < len; ++i) {
                    if (Character.isWhitespace(ch[i])) continue;
                    if (!params) continue block0;
                    params = false;
                    this.body = e;
                    continue block0;
                }
                continue;
            }
            if (!params) continue;
            params = false;
            this.body = e;
        }
        if (this.body == null) {
            this.body = this.getEndInstruction();
        }
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Event getBody() {
        return this.body;
    }

    public String getQname() {
        return this.qname;
    }
}

