/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class MRUMemoryStore
implements Store {
    private static final int MAX_OBJECTS = 100;
    private Log logger = LogFactory.getLog(this.getClass());
    private int maxObjects = 100;
    protected boolean persistent;
    private Store persistentStore;
    private StoreJanitor storeJanitor;
    private Hashtable cache;
    private LinkedList mrulist;

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    public void setMaxObjects(int maxobjects) {
        this.maxObjects = maxobjects;
    }

    public void setUsePersistentStore(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPersistentStore(Store persistentStore) {
        this.persistentStore = persistentStore;
    }

    public void setStoreJanitor(StoreJanitor storeJanitor) {
        this.storeJanitor = storeJanitor;
    }

    public void init() throws Exception {
        if (this.maxObjects < 1) {
            throw new Exception("MRUMemoryStore maxobjects must be at least 1!");
        }
        if (this.persistent && this.persistentStore == null) {
            throw new Exception("The persistent store must be set if usePersistentStore is required");
        }
        this.persistent = this.persistentStore != null;
        this.cache = new Hashtable((int)((double)this.maxObjects * 1.2));
        this.mrulist = new LinkedList();
        if (this.storeJanitor != null) {
            this.storeJanitor.register((Store)this);
        }
    }

    public void destroy() {
        this.getLogger().debug((Object)"Destroying component!");
        if (this.storeJanitor != null) {
            this.storeJanitor.unregister((Store)this);
        }
        if (this.persistent) {
            this.getLogger().debug((Object)("Final cache size: " + this.cache.size()));
            Enumeration enumer = this.cache.keys();
            while (enumer.hasMoreElements()) {
                Object key = enumer.nextElement();
                if (key == null) continue;
                try {
                    Object value = this.cache.remove(key);
                    if (!this.checkSerializable(value)) continue;
                    this.persistentStore.store(key, value);
                }
                catch (IOException ioe) {
                    this.getLogger().error((Object)"Error in dispose()", (Throwable)ioe);
                }
            }
        }
    }

    public synchronized void store(Object key, Object value) {
        this.hold(key, value);
    }

    public synchronized void hold(Object key, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Holding object in memory:");
            this.getLogger().debug((Object)("  key: " + key));
            this.getLogger().debug((Object)("  value: " + value));
        }
        while (this.mrulist.size() >= this.maxObjects) {
            this.free();
        }
        this.cache.put(key, value);
        this.mrulist.remove(key);
        this.mrulist.addFirst(key);
    }

    public synchronized Object get(Object key) {
        Object value = this.cache.get(key);
        if (value != null) {
            this.mrulist.remove(key);
            this.mrulist.addFirst(key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Found key: " + key.toString()));
            }
            return value;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("NOT Found key: " + key.toString()));
        }
        if (this.persistent && (value = this.persistentStore.get(key)) != null) {
            try {
                if (!this.cache.containsKey(key)) {
                    this.hold(key, value);
                }
                return value;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Error in get()!", (Throwable)e);
            }
        }
        return null;
    }

    public synchronized void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Removing object from store");
            this.getLogger().debug((Object)("  key: " + key));
        }
        this.cache.remove(key);
        this.mrulist.remove(key);
        if (this.persistent && key != null) {
            this.persistentStore.remove(key);
        }
    }

    public synchronized void clear() {
        Enumeration enumer = this.cache.keys();
        while (enumer.hasMoreElements()) {
            Object key = enumer.nextElement();
            if (key == null) continue;
            this.remove(key);
        }
    }

    public synchronized boolean containsKey(Object key) {
        if (this.persistent) {
            return this.cache.containsKey(key) || this.persistentStore.containsKey(key);
        }
        return this.cache.containsKey(key);
    }

    public synchronized Enumeration keys() {
        return this.cache.keys();
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized void free() {
        try {
            if (this.cache.size() > 0) {
                Object key = this.mrulist.removeLast();
                Object value = this.cache.remove(key);
                if (value == null) {
                    this.getLogger().warn((Object)"Concurrency condition in free()");
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Freeing cache.");
                    this.getLogger().debug((Object)("  key: " + key));
                    this.getLogger().debug((Object)("  value: " + value));
                }
                if (this.persistent && this.checkSerializable(value)) {
                    try {
                        this.persistentStore.store(key, value);
                    }
                    catch (Exception e) {
                        this.getLogger().error((Object)"Error storing object on fs", (Throwable)e);
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            this.getLogger().warn((Object)"Concurrency error in free()", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error in free()", (Throwable)e);
        }
    }

    private boolean checkSerializable(Object object) {
        return object instanceof Serializable;
    }
}

