/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl.javascript;

import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.el.ExpressionException;
import org.apache.cocoon.el.impl.AbstractExpression;
import org.apache.cocoon.el.impl.jexl.JSIntrospector;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.commons.jexl.util.introspection.Info;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavaScriptExpression
extends AbstractExpression {
    private Script script;
    private JSIntrospector introspector;
    private Scriptable rootScope;

    public JavaScriptExpression(String language, String expression, Scriptable rootScope) {
        super(language, expression);
        this.rootScope = rootScope;
        this.compile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile() {
        Context ctx = Context.enter();
        try {
            this.script = ctx.compileString(this.getExpression(), "", 1, null);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(ObjectModel objectModel) throws ExpressionException {
        Context ctx = Context.enter();
        try {
            Scriptable scope = ctx.newObject(this.getScope(this.rootScope));
            Iterator iter = objectModel.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                scope.put(key, scope, (Object)Context.toObject(value, (Scriptable)scope));
            }
            Object result = this.script.exec(ctx, scope);
            Object object = this.unwrap(result);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public Iterator iterate(ObjectModel objectModel) throws ExpressionException {
        Iterator iter;
        Object result = this.evaluate(objectModel);
        if (result == null) {
            return EMPTY_ITER;
        }
        if (this.introspector == null) {
            this.introspector = new JSIntrospector();
        }
        try {
            iter = this.introspector.getIterator(result, new Info("Unknown", 0, 0));
        }
        catch (Exception e) {
            throw new ExpressionException("Couldn't get an iterator from expression " + this.getExpression(), (Throwable)e);
        }
        if (iter == null) {
            iter = EMPTY_ITER;
        }
        return iter;
    }

    public void assign(ObjectModel objectModel, Object value) throws ExpressionException {
        throw new UnsupportedOperationException("assignment not implemented for javascript expressions");
    }

    public Object getNode(ObjectModel objectModel) throws ExpressionException {
        return this.evaluate(objectModel);
    }

    private Scriptable getScope(Scriptable rootScope) {
        Scriptable scope;
        Context ctx = Context.enter();
        try {
            scope = ctx.newObject(rootScope);
            scope.setPrototype(rootScope);
            scope.setParentScope(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception", e);
        }
        finally {
            Context.exit();
        }
        return scope;
    }

    private Object unwrap(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        } else if (obj == Undefined.instance) {
            obj = null;
        }
        return obj;
    }
}

