/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.spring.configurator.BlockResourcesHolder;
import org.apache.cocoon.spring.configurator.impl.DeploymentUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DefaultBlockResourcesHolder
extends PropertyPlaceholderConfigurer
implements BlockResourcesHolder,
BeanFactoryPostProcessor {
    protected Settings settings;
    protected boolean extractBlockResources = true;
    protected Map blockContexts = new HashMap();

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setExtractBlockResources(boolean extractBlockResources) {
        this.extractBlockResources = extractBlockResources;
    }

    public void init() throws Exception {
        this.blockContexts = this.extractBlockResources ? DeploymentUtil.deployBlockArtifacts(this.settings.getWorkDirectory()) : Collections.EMPTY_MAP;
    }

    public Map getBlockContexts() {
        return this.blockContexts;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        ResolvingBeanDefinitionVisitor visitor = new ResolvingBeanDefinitionVisitor(this.blockContexts);
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
            try {
                visitor.visitBeanDefinition(bd);
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
            }
        }
    }

    protected class ResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        protected final Properties props;
        protected final Set visitedPlaceholders = new HashSet();

        public ResolvingBeanDefinitionVisitor(Map blockContexts) {
            this.props = new Properties();
            Iterator i = blockContexts.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry current = i.next();
                String key = "org.apache.cocoon.blocks." + current.getKey() + ".resources";
                this.props.put(key, current.getValue().toString());
            }
        }

        protected String resolveStringValue(String strVal) {
            return DefaultBlockResourcesHolder.this.parseStringValue(strVal, this.props, this.visitedPlaceholders);
        }
    }
}

