/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.store.Store;

public abstract class AbstractReadWriteStore
extends AbstractLogEnabled
implements Store,
ThreadSafe,
Component {
    private ValueInstrument m_sizeInstrument = new ValueInstrument("size");
    private CounterInstrument m_hitsInstrument = new CounterInstrument("hits");
    private CounterInstrument m_missesInstrument = new CounterInstrument("misses");
    private String m_instrumentableName;
    protected ReadWriteLock lock = new FIFOReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object value = null;
        Sync sync = this.lock.readLock();
        try {
            sync.acquire();
            try {
                value = this.doGet(key);
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        if (null == value) {
            this.m_missesInstrument.increment();
        } else {
            this.m_hitsInstrument.increment();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object key, Object value) throws IOException {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doStore(key, value);
                this.m_sizeInstrument.setValue(this.doGetSize());
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doFree();
                this.m_sizeInstrument.setValue(this.doGetSize());
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("clear(): Clearing the database ");
        }
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doClear();
                this.m_sizeInstrument.setValue(0);
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doRemove(key);
                this.m_sizeInstrument.setValue(this.doGetSize());
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        boolean bl;
        Sync sync = this.lock.readLock();
        sync.acquire();
        try {
            bl = this.doContainsKey(key);
        }
        catch (Throwable throwable) {
            try {
                sync.release();
                throw throwable;
            }
            catch (InterruptedException ignore) {
                return false;
            }
        }
        sync.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() {
        Enumeration enumeration;
        Sync sync = this.lock.readLock();
        sync.acquire();
        try {
            enumeration = this.doGetKeys();
        }
        catch (Throwable throwable) {
            try {
                sync.release();
                throw throwable;
            }
            catch (InterruptedException ignore) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
        }
        sync.release();
        return enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n;
        Sync sync = this.lock.readLock();
        sync.acquire();
        try {
            n = this.doGetSize();
        }
        catch (Throwable throwable) {
            try {
                sync.release();
                throw throwable;
            }
            catch (InterruptedException ignore) {
                return 0;
            }
        }
        sync.release();
        return n;
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_sizeInstrument, this.m_hitsInstrument, this.m_missesInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    protected abstract Object doGet(Object var1);

    protected abstract void doStore(Object var1, Object var2) throws IOException;

    protected abstract void doFree();

    protected abstract void doRemove(Object var1);

    protected abstract void doClear();

    protected abstract boolean doContainsKey(Object var1);

    protected abstract Enumeration doGetKeys();

    protected abstract int doGetSize();
}

