/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.matching.AbstractPreparableMatcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;

public abstract class AbstractRegexpMatcher
extends AbstractPreparableMatcher
implements ThreadSafe {
    public Object preparePattern(String pattern) throws PatternException {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            pattern = "^$";
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"The empty pattern string was rewritten to '^$' to match for empty strings.  If you intended to match all strings, please change your pattern to '.*'");
            }
        }
        try {
            RECompiler compiler = new RECompiler();
            REProgram program = compiler.compile(pattern);
            return program;
        }
        catch (RESyntaxException rse) {
            this.getLogger().debug((Object)("Failed to compile the pattern '" + pattern + "'"), (Throwable)rse);
            throw new PatternException(rse.getMessage(), (Throwable)rse);
        }
    }

    public Map preparedMatch(Object preparedPattern, Map objectModel, Parameters parameters) throws PatternException {
        if (preparedPattern == null) {
            throw new PatternException("A pattern is needed at " + SitemapParameters.getLocation(parameters));
        }
        RE re = new RE((REProgram)preparedPattern);
        String match = this.getMatchString(objectModel, parameters);
        if (match == null) {
            return null;
        }
        if (re.match(match)) {
            int parenCount = re.getParenCount();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int paren = 0; paren <= parenCount; ++paren) {
                map.put(Integer.toString(paren), re.getParen(paren));
            }
            return map;
        }
        return null;
    }

    protected abstract String getMatchString(Map var1, Parameters var2);
}

