/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.io.IOException;
import java.io.InputStream;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SourceIOInputStream
extends InputStream {
    protected final InputStream delegate;
    protected final Source source;
    protected boolean closed;
    protected final SourceResolver resolver;

    public SourceIOInputStream(SourceResolver resolver, Source source) throws IOException {
        this.source = source;
        this.delegate = source.getInputStream();
        this.resolver = resolver;
    }

    public int available() throws IOException {
        this.check();
        return this.delegate.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            IOException e = null;
            try {
                this.delegate.close();
            }
            catch (IOException i) {
                e = i;
            }
            finally {
                this.resolver.release(this.source);
            }
            if (e != null) {
                throw e;
            }
        }
    }

    public void mark(int arg0) {
        this.delegate.mark(arg0);
    }

    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public int read() throws IOException {
        this.check();
        return this.delegate.read();
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        this.check();
        return this.delegate.read(arg0, arg1, arg2);
    }

    public int read(byte[] arg0) throws IOException {
        this.check();
        return this.delegate.read(arg0);
    }

    public void reset() throws IOException {
        this.check();
        this.delegate.reset();
    }

    public long skip(long arg0) throws IOException {
        this.check();
        return this.delegate.skip(arg0);
    }

    protected void check() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream has already been closed.");
        }
    }
}

