/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.SitemapErrorHandler;

public class TreeProcessorSitemapErrorHandler
implements SitemapErrorHandler {
    private ErrorHandlerHelper handler;
    private Environment environment;
    private InvokeContext context;
    private String envPrefix;
    private String envURI;

    public TreeProcessorSitemapErrorHandler(ErrorHandlerHelper handler, Environment environment, InvokeContext context) {
        this.handler = handler;
        this.environment = environment;
        this.context = context;
        this.envPrefix = environment.getURIPrefix();
        this.envURI = environment.getURI();
    }

    public boolean handleError(Exception e) throws Exception {
        this.environment.setURI(this.envPrefix, this.envURI);
        return this.handler.invokeErrorHandler(e, this.environment, this.context);
    }

    public ProcessingPipeline prepareErrorPipeline(Exception e) throws Exception {
        this.environment.setURI(this.envPrefix, this.envURI);
        Processor.InternalPipelineDescription pipelineDescription = this.handler.prepareErrorHandler(e, this.environment, this.context);
        return pipelineDescription != null ? pipelineDescription.processingPipeline : null;
    }
}

