/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.sitemap.SitemapErrorHandler;
import org.apache.cocoon.util.AbstractLogEnabled;

public class InvokeContext
extends AbstractLogEnabled
implements Serviceable,
Disposable {
    private List mapStack = new ArrayList();
    private Map nameToMap = new HashMap();
    private Map mapToName = new HashMap();
    private final boolean isBuildingPipelineOnly;
    protected Redirector redirector;
    private ServiceManager currentManager;
    private ObjectModel newObjectModel;
    protected Processor lastProcessor;
    protected SitemapErrorHandler errorHandler;
    private ServiceManager pipelinesManager;
    protected String processingPipelineType;
    protected Parameters processingPipelineParameters;
    protected ProcessingPipeline processingPipeline;
    protected Processor.InternalPipelineDescription internalPipelineDescription;

    public InvokeContext() {
        this.isBuildingPipelineOnly = false;
    }

    public InvokeContext(boolean isBuildingPipelineOnly) {
        this.isBuildingPipelineOnly = isBuildingPipelineOnly;
    }

    public InvokeContext(InvokeContext context, ServiceManager manager) throws ServiceException {
        this.isBuildingPipelineOnly = context.isBuildingPipelineOnly;
        this.redirector = context.redirector;
        this.lastProcessor = context.lastProcessor;
        this.service(manager);
        this.inform(context.processingPipelineType, context.processingPipelineParameters);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.currentManager = manager;
        if (this.processingPipeline != null) {
            this.processingPipeline.setProcessorManager(manager);
        }
        this.newObjectModel = (ObjectModel)manager.lookup(ObjectModel.ROLE);
    }

    public final boolean isBuildingPipelineOnly() {
        return this.isBuildingPipelineOnly;
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }

    public Redirector getRedirector() {
        return this.redirector;
    }

    public void setLastProcessor(Processor p) {
        this.lastProcessor = p;
    }

    public void inform(String pipelineType, Parameters parameters) {
        this.processingPipelineType = pipelineType;
        this.processingPipelineParameters = parameters;
    }

    public String getPipelineType() {
        return this.processingPipelineType;
    }

    public Parameters getPipelineParameters() {
        return this.processingPipelineParameters;
    }

    public void setErrorHandler(SitemapErrorHandler handler) {
        this.errorHandler = handler;
    }

    public boolean hasPipeline() {
        return this.processingPipeline != null;
    }

    public ProcessingPipeline getProcessingPipeline() throws Exception {
        if (this.processingPipeline == null) {
            this.pipelinesManager = this.currentManager;
            this.processingPipeline = (ProcessingPipeline)this.pipelinesManager.lookup(ProcessingPipeline.ROLE + '/' + this.processingPipelineType);
            this.processingPipeline.setProcessorManager(this.pipelinesManager);
            this.processingPipeline.setup(this.processingPipelineParameters);
            this.processingPipeline.setErrorHandler(this.errorHandler);
        }
        return this.processingPipeline;
    }

    public void setInternalPipelineDescription(Processor.InternalPipelineDescription desc) {
        this.processingPipeline = desc.processingPipeline;
        this.pipelinesManager = desc.pipelineManager;
        this.lastProcessor = desc.processor;
        this.internalPipelineDescription = new Processor.InternalPipelineDescription(this.lastProcessor, this.pipelinesManager, this.processingPipeline);
        this.internalPipelineDescription.prefix = desc.prefix;
        this.internalPipelineDescription.uri = desc.uri;
    }

    public Processor.InternalPipelineDescription getInternalPipelineDescription(Environment env) {
        if (this.internalPipelineDescription == null) {
            this.internalPipelineDescription = new Processor.InternalPipelineDescription(this.lastProcessor, this.pipelinesManager, this.processingPipeline);
            this.internalPipelineDescription.prefix = env.getURIPrefix();
            this.internalPipelineDescription.uri = env.getURI();
        }
        return this.internalPipelineDescription;
    }

    public final List getMapStack() {
        return this.mapStack;
    }

    public final Map getMapByAnchor(String anchor) {
        return (Map)this.nameToMap.get(anchor);
    }

    public final void pushMap(String anchorName, Map map) {
        String sitemapObjectModelPathPrefix = "sitemap";
        String sitemapObjectModelNamedPathPrefix = "sitemap/$named$";
        if (!this.isBuildingPipelineOnly()) {
            this.newObjectModel.markLocalContext();
        }
        this.mapStack.add(map);
        if (this.getLogger().isDebugEnabled()) {
            this.dumpParameters();
        }
        if (anchorName != null) {
            if (!this.nameToMap.containsKey(anchorName)) {
                this.nameToMap.put(anchorName, map);
                this.mapToName.put(map, anchorName);
            } else if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error((Object)("name [" + anchorName + "] clashes"));
            }
            this.newObjectModel.putAt("sitemap/$named$/" + anchorName, (Object)map);
        } else {
            this.newObjectModel.putAt("sitemap", (Object)map);
        }
    }

    public final void popMap() {
        Object map = this.mapStack.remove(this.mapStack.size() - 1);
        Object name = this.mapToName.get(map);
        this.mapToName.remove(map);
        this.nameToMap.remove(name);
        if (!this.isBuildingPipelineOnly()) {
            this.newObjectModel.cleanupLocalContext();
        }
    }

    protected void dumpParameters() {
        if (!this.mapStack.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nCurrent Sitemap Parameters:\n");
            String path = "";
            for (int i = this.mapStack.size() - 1; i >= 0; --i) {
                Map map = (Map)this.mapStack.get(i);
                sb.append("LEVEL ").append(i + 1);
                if (this.mapToName.containsKey(map)) {
                    sb.append(" is named '").append(String.valueOf(this.mapToName.get(map))).append("'");
                }
                sb.append("\n");
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry me = iter.next();
                    Object key = me.getKey();
                    sb.append("PARAM: '").append(path).append(key).append("' ");
                    sb.append("VALUE: '").append(map.get(key)).append("'\n");
                }
                path = "../" + path;
            }
            this.getLogger().debug((Object)sb.toString());
        }
    }

    public void dispose() {
        if (this.internalPipelineDescription == null && this.pipelinesManager != null) {
            if (this.processingPipeline != null) {
                this.pipelinesManager.release((Object)this.processingPipeline);
                this.processingPipeline = null;
            }
            this.pipelinesManager = null;
            this.processingPipelineType = null;
            this.processingPipelineParameters = null;
        }
        if (this.newObjectModel != null) {
            this.currentManager.release((Object)this.newObjectModel);
            this.newObjectModel = null;
        }
        this.currentManager = null;
    }
}

