/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.serialization.AbstractTextSerializer;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextSerializer
extends AbstractTextSerializer {
    private boolean hasRootElement;
    private boolean hadNoRootElement;

    public void init() throws Exception {
        super.init();
        this.format.put("method", "text");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.format.put("method", "text");
    }

    public void setOutputStream(OutputStream out) throws IOException {
        super.setOutputStream(out);
        try {
            TransformerHandler handler = this.getTransformerHandler();
            handler.getTransformer().setOutputProperties(this.format);
            handler.setResult(new StreamResult(this.output));
            this.setContentHandler(handler);
            this.setLexicalHandler(handler);
        }
        catch (Exception e) {
            String message = "Cannot set TextSerializer outputstream";
            throw new CascadingIOException("Cannot set TextSerializer outputstream", (Throwable)e);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.hasRootElement = true;
        super.startElement(uri, loc, raw, a);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (!this.hasRootElement) {
            this.hadNoRootElement = true;
            this.hasRootElement = true;
            this.getLogger().warn((Object)"Encountered text before root element. Creating <text> wrapper element.");
            super.startElement("", "text", "text", XMLUtils.EMPTY_ATTRIBUTES);
        }
        super.characters(c, start, len);
    }

    public void endDocument() throws SAXException {
        if (this.hadNoRootElement) {
            super.endElement("", "text", "text");
        }
        super.endDocument();
    }

    public void recycle() {
        super.recycle();
        this.hasRootElement = false;
        this.hadNoRootElement = false;
    }
}

