/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.RequestEncodingException;
import org.apache.cocoon.generation.RequestParseException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RequestGenerator
extends ServiceableGenerator
implements Parameterizable {
    private static final String PREFIX = "h";
    private static final String URI = "http://apache.org/cocoon/request/2.0";
    private String global_container_encoding;
    private String container_encoding;
    private String global_form_encoding;
    private String form_encoding;
    private boolean global_generate_attributes;
    private boolean generate_attributes;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.global_container_encoding = parameters.getParameter("container-encoding", "ISO-8859-1");
        this.global_form_encoding = parameters.getParameter("form-encoding", null);
        this.global_generate_attributes = parameters.getParameterAsBoolean("generate-attributes", false);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.container_encoding = parameters.getParameter("container-encoding", this.global_container_encoding);
        this.form_encoding = parameters.getParameter("form-encoding", this.global_form_encoding);
        this.generate_attributes = parameters.getParameterAsBoolean("generate-attributes", this.global_generate_attributes);
    }

    public void generate() throws SAXException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        AttributesImpl attr = new AttributesImpl();
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping(PREFIX, URI);
        this.attribute(attr, "target", request.getRequestURI());
        this.attribute(attr, "sitemap", request.getSitemapURI());
        this.attribute(attr, "source", this.source != null ? this.source : "");
        this.start("request", attr);
        this.start("requestHeaders", attr);
        Enumeration headers = request.getHeaderNames();
        if (headers != null) {
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                this.attribute(attr, "name", header);
                this.start("header", attr);
                this.data(request.getHeader(header));
                this.end("header");
            }
        }
        this.end("requestHeaders");
        this.start("requestParameters", attr);
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            this.attribute(attr, "name", parameter);
            this.start("parameter", attr);
            String[] values = request.getParameterValues(parameter);
            if (values != null) {
                for (int x = 0; x < values.length; ++x) {
                    this.start("value", attr);
                    if (this.form_encoding != null) {
                        try {
                            this.data(values[x], this.container_encoding, this.form_encoding);
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new RequestEncodingException("The suggested encoding is not supported.", (Throwable)uee);
                        }
                    } else if (parameter.startsWith("xml:")) {
                        this.parse(values[x]);
                    } else {
                        this.data(values[x]);
                    }
                    this.end("value");
                }
            }
            this.end("parameter");
        }
        this.end("requestParameters");
        if (this.generate_attributes) {
            this.start("requestAttributes", attr);
            Enumeration attributes = request.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String attribute = (String)attributes.nextElement();
                this.attribute(attr, "name", attribute);
                this.start("attribute", attr);
                Object value = request.getAttribute(attribute);
                if (value != null) {
                    this.start("value", attr);
                    XMLUtils.valueOf((ContentHandler)this.contentHandler, (Object)value);
                    this.end("value");
                }
                this.end("attribute");
            }
            this.end("requestAttributes");
        }
        this.start("configurationParameters", attr);
        String[] confparams = this.parameters.getNames();
        for (int i = 0; i < confparams.length; ++i) {
            this.attribute(attr, "name", confparams[i]);
            this.start("parameter", attr);
            this.data(this.parameters.getParameter(confparams[i], ""));
            this.end("parameter");
        }
        this.end("configurationParameters");
        this.start("remoteUser", attr);
        if (request.getRemoteUser() != null) {
            this.data(request.getRemoteUser());
        }
        this.end("remoteUser");
        this.end("request");
        this.contentHandler.endPrefixMapping(PREFIX);
        this.contentHandler.endDocument();
    }

    private void attribute(AttributesImpl attr, String name, String value) {
        attr.addAttribute("", name, name, "CDATA", value);
    }

    private void start(String name, AttributesImpl attr) throws SAXException {
        this.contentHandler.startElement(URI, name, "h:" + name, attr);
        attr.clear();
    }

    private void end(String name) throws SAXException {
        this.contentHandler.endElement(URI, name, "h:" + name);
    }

    private void data(String data) throws SAXException {
        this.contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    private void data(String data, String container_encoding, String form_encoding) throws SAXException, UnsupportedEncodingException {
        this.data(new String(data.getBytes(container_encoding), form_encoding));
    }

    private void parse(String data) throws SAXException {
        SAXParser parser = null;
        try {
            parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            InputSource is = new InputSource(new StringReader(data));
            parser.parse(is, (ContentHandler)new IncludeXMLConsumer(this.xmlConsumer));
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new RequestParseException("Could not parse the parameters.", e);
        }
        finally {
            this.manager.release((Object)parser);
        }
    }
}

