/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.cocoon.generation.DirectoryGenerator;
import org.apache.cocoon.util.FileFormatException;
import org.apache.cocoon.util.ImageProperties;
import org.apache.cocoon.util.ImageUtils;
import org.xml.sax.SAXException;

public final class ImageDirectoryGenerator
extends DirectoryGenerator {
    protected static final String IMAGE_WIDTH_ATTR_NAME = "width";
    protected static final String IMAGE_HEIGHT_ATTR_NAME = "height";
    protected static final String IMAGE_COMMENT_ATTR_NAME = "comment";

    protected void setNodeAttributes(File path) throws SAXException {
        super.setNodeAttributes(path);
        if (path.isDirectory()) {
            return;
        }
        try {
            ImageProperties p = ImageUtils.getImageProperties((File)path);
            if (p != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(String.valueOf(path) + " = " + String.valueOf(p)));
                }
                this.attributes.addAttribute("", IMAGE_WIDTH_ATTR_NAME, IMAGE_WIDTH_ATTR_NAME, "CDATA", String.valueOf(p.width));
                this.attributes.addAttribute("", IMAGE_HEIGHT_ATTR_NAME, IMAGE_HEIGHT_ATTR_NAME, "CDATA", String.valueOf(p.height));
                if (p.comment != null) {
                    this.attributes.addAttribute("", IMAGE_COMMENT_ATTR_NAME, IMAGE_COMMENT_ATTR_NAME, "CDATA", String.valueOf(p.comment));
                }
            }
        }
        catch (FileFormatException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

