/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xpointer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.xpointer.PointerPart;
import org.apache.cocoon.components.xpointer.XPointerContext;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.excalibur.source.Source;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ElementPathPart
implements PointerPart {
    private String expression;

    public ElementPathPart(String expression) {
        this.expression = expression;
    }

    public boolean process(XPointerContext xpointerContext) throws SAXException {
        PathInclusionPipe pipe = new PathInclusionPipe(this.expression, xpointerContext);
        pipe.setConsumer(xpointerContext.getXmlConsumer());
        try {
            SourceUtil.toSAX((ServiceManager)xpointerContext.getServiceManager(), (Source)xpointerContext.getSource(), (ContentHandler)((Object)pipe));
        }
        catch (IOException e) {
            throw new SAXException("Exception while trying to XInclude data: " + e.getMessage(), e);
        }
        catch (ProcessingException e) {
            throw new SAXException("Exception while trying to XInclude data: " + e.getMessage(), (Exception)((Object)e));
        }
        return true;
    }

    public static class PathInclusionPipe
    extends AbstractXMLPipe {
        private QName[] elementPath;
        private int level;
        private boolean include;
        private int includeLevel;
        private int levelToMatch;
        private boolean done;

        public PathInclusionPipe(String expression, XPointerContext xpointerContext) throws SAXException {
            ArrayList<QName> path = new ArrayList<QName>();
            StringTokenizer tokenizer = new StringTokenizer(expression, "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    path.add(QName.parse(token, xpointerContext));
                }
                catch (SAXException e) {
                    throw new SAXException("Error in element path xpointer expression \"" + expression + "\": " + e.getMessage());
                }
            }
            if (path.size() < 1) {
                throw new SAXException("Invalid element path xpointer expression \"" + expression + "\".");
            }
            this.elementPath = path.toArray(new QName[0]);
            this.level = -1;
            this.include = false;
            this.levelToMatch = 0;
            this.done = false;
        }

        public void startElement(String namespaceURI, String localName, String raw, Attributes a) throws SAXException {
            ++this.level;
            if (this.include) {
                super.startElement(namespaceURI, localName, raw, a);
                return;
            }
            if (!this.done && this.level == this.levelToMatch && this.elementPath[this.level].matches(namespaceURI, localName)) {
                ++this.levelToMatch;
                if (this.levelToMatch == this.elementPath.length) {
                    this.include = true;
                    this.done = true;
                    this.includeLevel = this.level;
                }
            }
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            if (this.include && this.level == this.includeLevel) {
                this.include = false;
            }
            if (this.include) {
                super.endElement(uri, loc, raw);
            }
            --this.level;
        }

        public void setDocumentLocator(Locator locator) {
            if (this.include) {
                super.setDocumentLocator(locator);
            }
        }

        public void startDocument() throws SAXException {
            if (this.include) {
                super.startDocument();
            }
        }

        public void endDocument() throws SAXException {
            if (this.include) {
                super.endDocument();
            }
        }

        public void characters(char[] c, int start, int len) throws SAXException {
            if (this.include) {
                super.characters(c, start, len);
            }
        }

        public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
            if (this.include) {
                super.ignorableWhitespace(c, start, len);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.include) {
                super.processingInstruction(target, data);
            }
        }

        public void skippedEntity(String name) throws SAXException {
            if (this.include) {
                super.skippedEntity(name);
            }
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.include) {
                super.startDTD(name, publicId, systemId);
            }
        }

        public void endDTD() throws SAXException {
            if (this.include) {
                super.endDTD();
            }
        }

        public void startEntity(String name) throws SAXException {
            if (this.include) {
                super.startEntity(name);
            }
        }

        public void endEntity(String name) throws SAXException {
            if (this.include) {
                super.endEntity(name);
            }
        }

        public void startCDATA() throws SAXException {
            if (this.include) {
                super.startCDATA();
            }
        }

        public void endCDATA() throws SAXException {
            if (this.include) {
                super.endCDATA();
            }
        }

        public void comment(char[] ch, int start, int len) throws SAXException {
            if (this.include) {
                super.comment(ch, start, len);
            }
        }

        public static class QName {
            private String namespaceURI;
            private String localName;

            public QName(String namespaceURI, String localName) {
                this.namespaceURI = namespaceURI;
                this.localName = localName;
            }

            public static QName parse(String qName, XPointerContext xpointerContext) throws SAXException {
                int pos = qName.indexOf(58);
                if (pos > 0) {
                    String prefix = qName.substring(0, pos);
                    String localName = qName.substring(pos + 1);
                    String namespaceURI = xpointerContext.prefixToNamespace(prefix);
                    if (namespaceURI == null) {
                        throw new SAXException("Namespace prefix \"" + prefix + "\" not declared.");
                    }
                    return new QName(prefix, localName);
                }
                return new QName("", qName);
            }

            public String getNamespaceURI() {
                return this.namespaceURI;
            }

            public String getLocalName() {
                return this.localName;
            }

            public boolean matches(String namespaceURI, String localName) {
                return this.localName.equals(localName) && this.namespaceURI.equals(namespaceURI);
            }
        }
    }
}

