/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EmptySource
implements XMLizable,
Source {
    protected String rootElementName;
    protected String scheme;
    protected String uri;
    protected String xmlDocument;

    public EmptySource(String location) {
        this.uri = location;
        int pos = location.indexOf(58);
        this.scheme = location.substring(0, pos);
        String rootName = location.substring(pos + 1).trim();
        if (rootName.length() > 0) {
            this.rootElementName = rootName;
            this.xmlDocument = '<' + this.rootElementName + "/>";
        } else {
            this.xmlDocument = "";
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        handler.startDocument();
        if (this.rootElementName != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)this.rootElementName);
        }
        handler.endDocument();
    }

    public boolean exists() {
        return true;
    }

    public long getContentLength() {
        return this.xmlDocument.length();
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        return new ByteArrayInputStream(this.xmlDocument.getBytes("utf-8"));
    }

    public long getLastModified() {
        return 1L;
    }

    public String getMimeType() {
        return "text/xml";
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getURI() {
        return this.uri;
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void refresh() {
    }
}

