/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.store.Store;

public class CacheImpl
implements Cache {
    private Log logger = LogFactory.getLog(this.getClass());
    protected Store store;

    public void store(Serializable key, CachedResponse response) throws ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("Caching new response for " + key));
        }
        try {
            this.store.store((Object)key, (Object)response);
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to cache response.", (Throwable)e);
        }
    }

    public CachedResponse get(Serializable key) {
        CachedResponse r = (CachedResponse)this.store.get((Object)key);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("Cache " + (r == null ? "MISS" : "HIT") + " for " + key));
        }
        return r;
    }

    public void remove(Serializable key) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("Removing cached response for " + key));
        }
        this.store.remove((Object)key);
    }

    public void clear() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)"Clearing cache");
        }
        this.store.clear();
    }

    public boolean containsKey(Serializable key) {
        return this.store.containsKey((Object)key);
    }

    public void setStore(Store store) {
        this.store = store;
    }

    protected Log getLogger() {
        return this.logger;
    }
}

