/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DeploymentUtil {
    protected static final Log logger = LogFactory.getLog((Class)DeploymentUtil.class);
    protected static final String BLOCK_RESOURCES_PATH = "COB-INF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploy(JarFile jarFile, String prefix, String destination) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deploying jar " + jarFile + " to " + destination));
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            InputStream inStream;
            block6: {
                Object var10_9;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(prefix)) continue;
                String fileName = destination + entry.getName().substring(prefix.length());
                File out = new File(fileName);
                out.getParentFile().mkdirs();
                inStream = null;
                FileOutputStream outStream = null;
                try {
                    inStream = jarFile.getInputStream(entry);
                    outStream = new FileOutputStream(out);
                    IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
                    var10_9 = null;
                    if (outStream == null) break block6;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    if (outStream != null) {
                        ((OutputStream)outStream).close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                    throw throwable;
                }
                ((OutputStream)outStream).close();
            }
            if (inStream == null) continue;
            inStream.close();
            {
            }
        }
    }

    protected static void deployBlockResources(String relativeDirectory, String destinationDirectory, Map blockContexts) throws IOException {
        Enumeration<URL> jarUrls = DeploymentUtil.class.getClassLoader().getResources(BLOCK_RESOURCES_PATH);
        while (jarUrls.hasMoreElements()) {
            URL jarUrl;
            JarURLConnection connection;
            JarFile jarFile;
            String blockName;
            int pos;
            URL resourceUrl = jarUrls.nextElement();
            String url = resourceUrl.toExternalForm();
            if ("file".equals(resourceUrl.getProtocol())) {
                pos = url.indexOf("/target/classes/COB-INF");
                if (pos < 0) continue;
                String blockName2 = url.substring(0, pos);
                blockName2 = blockName2.substring(blockName2.lastIndexOf(47) + 1);
                blockContexts.put(blockName2, url);
                continue;
            }
            if (!"jar".equals(resourceUrl.getProtocol()) && !"zip".equals(resourceUrl.getProtocol())) continue;
            pos = url.indexOf(33);
            url = url.substring(0, pos + 2);
            if ("zip".equals(resourceUrl.getProtocol())) {
                url = url.replaceAll("zip:", "jar:file:");
            }
            if ((blockName = (jarFile = (connection = (JarURLConnection)(jarUrl = new URL(url)).openConnection()).getJarFile()).getManifest().getMainAttributes().getValue("Cocoon-Block-Name")) == null) {
                String jarPath = jarFile.getName();
                String jarName = jarPath.substring(jarPath.lastIndexOf(File.separatorChar) + 1);
                blockName = jarName.substring(0, jarName.lastIndexOf(46));
            }
            StringBuffer buffer = new StringBuffer(destinationDirectory);
            buffer.append(File.separatorChar);
            buffer.append(relativeDirectory);
            buffer.append(File.separatorChar);
            buffer.append(blockName);
            String destination = buffer.toString();
            DeploymentUtil.deploy(jarFile, BLOCK_RESOURCES_PATH, destination);
            blockContexts.put(blockName, new File(destination).toURL().toExternalForm());
        }
    }

    public static Map deployBlockArtifacts(String destinationDirectory) throws IOException {
        if (destinationDirectory == null) {
            throw new IllegalArgumentException("Destination must not be null.");
        }
        HashMap blockContexts = new HashMap();
        DeploymentUtil.deployBlockResources("blocks", destinationDirectory, blockContexts);
        return blockContexts;
    }

    public static void deployJarResources(String pattern, String destinationDirectory) throws IOException {
        Enumeration<URL> jarUrls = DeploymentUtil.class.getClassLoader().getResources(pattern);
        while (jarUrls.hasMoreElements()) {
            URL resourceUrl = jarUrls.nextElement();
            String url = resourceUrl.toExternalForm();
            if (!"jar".equals(resourceUrl.getProtocol())) continue;
            int pos = url.indexOf(33);
            url = url.substring(0, pos + 2);
            URL jarUrl = new URL(url);
            JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
            JarFile jarFile = connection.getJarFile();
            DeploymentUtil.deploy(jarFile, pattern, destinationDirectory);
        }
    }
}

