/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.net.UnknownHostException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICachePeer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIRMICacheManagerPeerListener
extends RMICacheManagerPeerListener
implements CacheManagerPeerListener {
    private static final Log LOG = LogFactory.getLog((String)JNDIRMICacheManagerPeerListener.class.getName());

    public JNDIRMICacheManagerPeerListener(String hostName, Integer port, CacheManager cacheManager, Integer socketTimeoutMillis) throws UnknownHostException {
        super(hostName, port, cacheManager, socketTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws CacheException {
        RMICachePeer rmiCachePeer = null;
        String peerName = null;
        int counter = 0;
        try {
            Context initialContext = this.getInitialContext();
            this.populateListOfRemoteCachePeers();
            Map map = this.cachePeers;
            synchronized (map) {
                Iterator iterator = this.cachePeers.values().iterator();
                while (iterator.hasNext()) {
                    rmiCachePeer = (RMICachePeer)iterator.next();
                    peerName = rmiCachePeer.getName();
                    LOG.debug((Object)("binding " + peerName));
                    initialContext.rebind(peerName, (Object)rmiCachePeer);
                    ++counter;
                }
            }
            LOG.debug((Object)(counter + " RMICachePeers bound in JNDI for RMI listener"));
        }
        catch (Exception e) {
            throw new CacheException("Problem starting listener for RMICachePeer " + peerName + " .Error was " + e.getMessage(), e);
        }
    }

    private Context getInitialContext() throws NamingException {
        String initialContextFactory = System.getProperty("java.naming.factory.initial");
        if (initialContextFactory != null && initialContextFactory.startsWith("net.sf.ehcache")) {
            Hashtable<String, String> hashTable = new Hashtable<String, String>();
            hashTable.put("java.naming.provider.url", "//localhost:" + this.port);
            return new InitialContext(hashTable);
        }
        return new InitialContext();
    }

    protected void disposeRMICachePeer(RMICachePeer rmiCachePeer) throws Exception {
        this.getInitialContext().unbind(rmiCachePeer.getName());
        UnicastRemoteObject.unexportObject(rmiCachePeer, false);
    }
}

