/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.components;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class LinkRewriterReader
extends AbstractReader
implements CacheableProcessingComponent {
    protected long configuredExpires = -1L;
    protected String configuredEncoding = "UTF-8";
    protected Response response;
    protected Request request;
    protected Source inputSource;
    protected InputModule inputModule;
    protected long expires;
    protected String encoding;

    public void setExpires(long expires) {
        this.configuredExpires = expires;
    }

    public void setEncoding(String encoding) {
        this.configuredEncoding = encoding;
    }

    public void setInputModule(InputModule inputModule) {
        this.inputModule = inputModule;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.expires = par.getParameterAsLong("expires", this.configuredExpires);
        this.encoding = par.getParameter("encoding", this.configuredEncoding);
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException e) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)e);
        }
        this.setupHeaders();
    }

    protected void setupHeaders() {
        this.response.setHeader("Accept-Ranges", "none");
        if (this.expires > 0L) {
            this.response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
        } else if (this.expires == 0L) {
            this.response.setDateHeader("Expires", 0L);
        }
        long lastModified = this.inputSource.getLastModified();
        if (lastModified > 0L) {
            this.response.setDateHeader("Last-Modified", lastModified);
        }
    }

    public void generate() throws IOException, ProcessingException {
        InputStream inputStream = this.inputSource.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.encoding);
        BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter(this.out, this.encoding));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = bufferedReader.readLine();
        int lineNumber = 1;
        while (line != null) {
            line = this.proccessLine(line, lineNumber);
            outputWriter.write(line, 0, line.length());
            outputWriter.newLine();
            line = bufferedReader.readLine();
            ++lineNumber;
        }
        bufferedReader.close();
        outputWriter.close();
    }

    protected String proccessLine(String line, int lineNumber) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Processing line: " + line));
        }
        Matcher matcher = URIregexp.compiledURIpattern.matcher(line);
        StringBuffer sb = new StringBuffer(line.length());
        while (matcher.find()) {
            Object replacement;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Processing link: " + matcher.group(0)));
            }
            String link = matcher.group(1);
            try {
                replacement = this.inputModule.getAttribute(link, null, this.objectModel);
            }
            catch (ConfigurationException e) {
                throw ProcessingException.throwLocated((String)"Failed to obtain attribute from input module", (Throwable)e, (Location)new LocationImpl(null, this.inputSource.getURI(), lineNumber, matcher.start()));
            }
            if (!(replacement instanceof String)) {
                throw new ProcessingException("Attribute named '" + link + "' obtained from 'servlet' input module has to be String object.", (Location)new LocationImpl(null, this.inputSource.getURI(), lineNumber, matcher.start()));
            }
            matcher.appendReplacement(sb, (String)replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String getMimeType() {
        String mimeType;
        Context ctx = ObjectModelHelper.getContext((Map)this.objectModel);
        if (ctx != null && (mimeType = ctx.getMimeType(this.source)) != null) {
            return mimeType;
        }
        return this.inputSource.getMimeType();
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    protected static class URIregexp {
        static final String scheme = "(?:[a-zA-Z](?:[a-zA-Z0-9]|\\+|-|\\.)*)";
        static final String mark = "-|_|\\.|!|~|\\*|'|\\(|\\)";
        static final String unreserved = "[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)";
        static final String escaped = "%[a-fA-F0-9]{2}";
        static final String pChar = "[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,";
        static final String pathSegment = "(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*(?:;(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*)*";
        static final String absPath = "(?:/(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*(?:;(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*)*)+";
        static final String reserved = ";|/|\\?|:|@|&|=|\\+|\\$|,";
        static final String uric = ";|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}";
        static final String hierPath = "(?:/(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*(?:;(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*)*)+(?:\\?(?:;|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2})*)*";
        static final String URIpattern = "servlet:((?:(?:[a-zA-Z](?:[a-zA-Z0-9]|\\+|-|\\.)*):)??(?:/(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*(?:;(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*)*)+(?:\\?(?:;|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2})*)*(?:#(?:;|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2})*)*)";
        static final Pattern compiledURIpattern = Pattern.compile("servlet:((?:(?:[a-zA-Z](?:[a-zA-Z0-9]|\\+|-|\\.)*):)??(?:/(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*(?:;(?:[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2}|:|@|&|=|\\+|\\$|,)*)*)+(?:\\?(?:;|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2})*)*(?:#(?:;|/|\\?|:|@|&|=|\\+|\\$|,|[a-zA-Z0-9]|-|_|\\.|!|~|\\*|'|\\(|\\)|%[a-fA-F0-9]{2})*)*)");

        protected URIregexp() {
        }
    }
}

