/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.pipeline.impl.PipelineComponentInfo;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.avalon.AvalonBeanPostProcessor;
import org.apache.cocoon.core.container.spring.avalon.AvalonContextFactoryBean;
import org.apache.cocoon.core.container.spring.avalon.AvalonServiceManager;
import org.apache.cocoon.core.container.spring.avalon.ComponentInfo;
import org.apache.cocoon.core.container.spring.avalon.ConfigurationInfo;
import org.apache.cocoon.core.container.spring.avalon.ConfigurationInfoFactoryBean;
import org.apache.cocoon.core.container.spring.avalon.ConfigurationReader;
import org.apache.cocoon.core.container.spring.logger.LoggerFactoryBean;
import org.apache.cocoon.core.container.spring.pipeline.PipelineComponentInfoFactoryBean;
import org.apache.cocoon.core.container.spring.pipeline.PipelineComponentInfoInitializer;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.spring.configurator.impl.AbstractElementParser;
import org.apache.cocoon.transformation.Transformer;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Element;

public class BridgeElementParser
extends AbstractElementParser {
    public static final String DEFAULT_COCOON_XCONF_LOCATION = "resource://org/apache/cocoon/cocoon.xconf";
    static /* synthetic */ Class class$org$apache$cocoon$core$container$spring$avalon$AvalonServiceSelector;
    static /* synthetic */ Class class$org$apache$avalon$framework$thread$ThreadSafe;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$pool$Poolable;
    static /* synthetic */ Class class$org$apache$cocoon$core$container$spring$avalon$PoolableFactoryBean;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        ResourceLoader resourceLoader = parserContext.getReaderContext().getReader().getResourceLoader();
        String location = this.getAttributeValue(element, "location", DEFAULT_COCOON_XCONF_LOCATION);
        try {
            ConfigurationInfo info = this.readConfiguration(location, resourceLoader);
            this.createComponents(element, info, parserContext.getRegistry(), (BeanDefinitionReader)parserContext.getDelegate().getReaderContext().getReader(), resourceLoader);
        }
        catch (Exception e) {
            throw new BeanDefinitionStoreException("Unable to read Avalon configuration from '" + location + "'.", (Throwable)e);
        }
        return null;
    }

    public void createComponents(Element element, ConfigurationInfo info, BeanDefinitionRegistry registry, BeanDefinitionReader reader, ResourceLoader resourceLoader) throws Exception {
        this.addContext(element, registry);
        this.addComponent(AvalonServiceManager.class, "org.apache.avalon.framework.service.ServiceManager", null, false, registry);
        this.addLogger(registry, info.getRootLogger());
        Iterator includeIter = info.getImports().iterator();
        while (includeIter.hasNext()) {
            if (reader == null) {
                throw new Exception("Import of spring configuration files not supported. (Reader is null)");
            }
            String uri = (String)includeIter.next();
            reader.loadBeanDefinitions(resourceLoader.getResource(uri));
        }
        this.createConfig(info, registry);
        this.registerComponentInfo(info, registry);
        RootBeanDefinition beanDef = this.createBeanDefinition(AvalonBeanPostProcessor.class, "init", true);
        beanDef.getPropertyValues().addPropertyValue("context", (Object)new RuntimeBeanReference("org.apache.avalon.framework.context.Context"));
        beanDef.getPropertyValues().addPropertyValue("configurationInfo", (Object)new RuntimeBeanReference(ConfigurationInfo.class.getName()));
        beanDef.getPropertyValues().addPropertyValue("resourceLoader", (Object)resourceLoader);
        beanDef.getPropertyValues().addPropertyValue("location", (Object)this.getConfigurationLocation());
        this.register((BeanDefinition)beanDef, AvalonBeanPostProcessor.class.getName(), registry);
        RootBeanDefinition resolverDef = new RootBeanDefinition();
        resolverDef.setBeanClassName("org.apache.cocoon.components.treeprocessor.variables.PreparedVariableResolver");
        resolverDef.setLazyInit(false);
        resolverDef.setScope("prototype");
        resolverDef.getPropertyValues().addPropertyValue("manager", (Object)new RuntimeBeanReference("org.apache.avalon.framework.service.ServiceManager"));
        this.register((BeanDefinition)resolverDef, "org.apache.cocoon.components.treeprocessor.variables.VariableResolver", null, registry);
    }

    protected ConfigurationInfo readConfiguration(String location, ResourceLoader resourceLoader) throws Exception {
        return ConfigurationReader.readConfiguration(location, resourceLoader);
    }

    protected void addContext(Element element, BeanDefinitionRegistry registry) {
        this.addComponent(AvalonContextFactoryBean.class, "org.apache.avalon.framework.context.Context", "init", true, registry);
    }

    protected void addLogger(BeanDefinitionRegistry registry, String loggerCategory) {
        RootBeanDefinition beanDef = this.createBeanDefinition(LoggerFactoryBean.class, "init", false);
        if (loggerCategory != null) {
            beanDef.getPropertyValues().addPropertyValue("category", (Object)loggerCategory);
        }
        this.register((BeanDefinition)beanDef, "org.apache.cocoon.core.container.spring.logger.Log", registry);
    }

    public void createConfig(ConfigurationInfo info, BeanDefinitionRegistry registry) throws Exception {
        Map components = info.getComponents();
        ArrayList<String> pooledRoles = new ArrayList<String>();
        Iterator i = components.entrySet().iterator();
        while (i.hasNext()) {
            String poolMax;
            Map.Entry entry = i.next();
            ComponentInfo current = (ComponentInfo)entry.getValue();
            String role = current.getRole();
            String className = current.getComponentClassName();
            boolean isSelector = false;
            boolean singleton = true;
            boolean poolable = false;
            if (current.isSelector()) {
                className = (class$org$apache$cocoon$core$container$spring$avalon$AvalonServiceSelector == null ? BridgeElementParser.class$("org.apache.cocoon.core.container.spring.avalon.AvalonServiceSelector") : class$org$apache$cocoon$core$container$spring$avalon$AvalonServiceSelector).getName();
                isSelector = true;
            } else {
                if (current.getModel() == -1) {
                    try {
                        Class<?> serviceClass = Class.forName(className);
                        if ((class$org$apache$avalon$framework$thread$ThreadSafe == null ? BridgeElementParser.class$("org.apache.avalon.framework.thread.ThreadSafe") : class$org$apache$avalon$framework$thread$ThreadSafe).isAssignableFrom(serviceClass)) {
                            current.setModel(1);
                        } else if ((class$org$apache$avalon$excalibur$pool$Poolable == null ? BridgeElementParser.class$("org.apache.avalon.excalibur.pool.Poolable") : class$org$apache$avalon$excalibur$pool$Poolable).isAssignableFrom(serviceClass)) {
                            current.setModel(2);
                        } else {
                            current.setModel(0);
                        }
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        throw new ConfigurationException("Unable to create class for component with role " + current.getRole() + " with class: " + className, (Throwable)ncdfe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new ConfigurationException("Unable to create class for component with role " + current.getRole() + " with class: " + className, (Throwable)cnfe);
                    }
                }
                if (current.getModel() == 2) {
                    poolable = true;
                    singleton = false;
                } else if (current.getModel() != 1) {
                    singleton = false;
                }
            }
            String beanName = !poolable ? role : role + "Pooled";
            RootBeanDefinition beanDef = new RootBeanDefinition();
            beanDef.setBeanClassName(className);
            if (current.getInitMethodName() != null) {
                beanDef.setInitMethodName(current.getInitMethodName());
            }
            if (current.getDestroyMethodName() != null) {
                beanDef.setDestroyMethodName(current.getDestroyMethodName());
            }
            beanDef.setSingleton(singleton);
            beanDef.setLazyInit(singleton && current.isLazyInit());
            if (isSelector) {
                beanDef.getConstructorArgumentValues().addGenericArgumentValue((Object)role.substring(0, role.length() - 8), "java.lang.String");
                if (current.getDefaultValue() != null) {
                    beanDef.getPropertyValues().addPropertyValue("default", (Object)current.getDefaultValue());
                }
            }
            this.register((BeanDefinition)beanDef, beanName, current.getAlias(), registry);
            if (!poolable) continue;
            RootBeanDefinition poolableBeanDef = new RootBeanDefinition();
            poolableBeanDef.setBeanClass(class$org$apache$cocoon$core$container$spring$avalon$PoolableFactoryBean == null ? BridgeElementParser.class$("org.apache.cocoon.core.container.spring.avalon.PoolableFactoryBean") : class$org$apache$cocoon$core$container$spring$avalon$PoolableFactoryBean);
            poolableBeanDef.setSingleton(true);
            poolableBeanDef.setLazyInit(false);
            poolableBeanDef.setInitMethodName("initialize");
            poolableBeanDef.setDestroyMethodName("dispose");
            poolableBeanDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanName, "java.lang.String");
            poolableBeanDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)className, "java.lang.String");
            if (current.getConfiguration() != null && (poolMax = current.getConfiguration().getAttribute("pool-max", null)) != null) {
                poolableBeanDef.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)poolMax);
                poolableBeanDef.getConstructorArgumentValues().addIndexedArgumentValue(3, (Object)new RuntimeBeanReference(Settings.ROLE));
            }
            if (current.getPoolInMethodName() != null) {
                poolableBeanDef.getPropertyValues().addPropertyValue("poolInMethodName", (Object)current.getPoolInMethodName());
            }
            if (current.getPoolOutMethodName() != null) {
                poolableBeanDef.getPropertyValues().addPropertyValue("poolOutMethodName", (Object)current.getPoolOutMethodName());
            }
            this.register((BeanDefinition)poolableBeanDef, role, registry);
            pooledRoles.add(role);
        }
        Iterator prI = pooledRoles.iterator();
        while (prI.hasNext()) {
            String role = (String)prI.next();
            Object pooledInfo = components.remove(role);
            components.put(role + "Pooled", pooledInfo);
        }
    }

    protected void registerComponentInfo(ConfigurationInfo configInfo, BeanDefinitionRegistry registry) {
        PipelineComponentInfo info = new PipelineComponentInfo(null);
        Iterator i = configInfo.getComponents().values().iterator();
        while (i.hasNext()) {
            ComponentInfo current = (ComponentInfo)i.next();
            info.componentAdded(current.getRole(), current.getComponentClassName(), current.getConfiguration());
        }
        BridgeElementParser.prepareSelector(info, configInfo, Generator.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Transformer.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Serializer.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, ProcessingPipeline.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Action.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Selector.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Matcher.ROLE);
        BridgeElementParser.prepareSelector(info, configInfo, Reader.ROLE);
        info.lock();
        if (!registry.containsBeanDefinition(PipelineComponentInfo.ROLE)) {
            RootBeanDefinition beanDef = new RootBeanDefinition();
            beanDef.setBeanClass(PipelineComponentInfoFactoryBean.class);
            beanDef.setSingleton(true);
            beanDef.setLazyInit(false);
            beanDef.setInitMethodName("init");
            this.register((BeanDefinition)beanDef, PipelineComponentInfo.ROLE, registry);
        }
        BeanDefinitionBuilder initDefBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)PipelineComponentInfoInitializer.class);
        initDefBuilder.addPropertyReference("info", PipelineComponentInfo.ROLE);
        initDefBuilder.setSingleton(true);
        initDefBuilder.setLazyInit(false);
        initDefBuilder.setInitMethodName("init");
        initDefBuilder.addPropertyValue("data", (Object)info.getData());
        String beanName = ((Object)((Object)this)).getClass().getName() + "/init";
        this.register((BeanDefinition)initDefBuilder.getBeanDefinition(), beanName, registry);
        RootBeanDefinition ciBeanDef = new RootBeanDefinition();
        ciBeanDef.setBeanClass(ConfigurationInfoFactoryBean.class);
        ciBeanDef.setSingleton(true);
        ciBeanDef.setLazyInit(false);
        ciBeanDef.getPropertyValues().addPropertyValue("configurationInfo", (Object)configInfo);
        this.register((BeanDefinition)ciBeanDef, ConfigurationInfo.class.getName(), registry);
    }

    protected static void prepareSelector(PipelineComponentInfo info, ConfigurationInfo configInfo, String category) {
        ComponentInfo component = (ComponentInfo)configInfo.getComponents().get(category + "Selector");
        if (component != null) {
            info.setDefaultType(category, component.getDefaultValue());
        }
    }

    protected String getConfigurationLocation() {
        return "WEB-INF/cocoon/xconf";
    }
}

