/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.avalon.ComponentContext;
import org.apache.cocoon.environment.http.HttpContext;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.web.context.ServletContextAware;

public class AvalonContextFactoryBean
implements FactoryBean,
ServletContextAware {
    protected ServletContext servletContext;
    protected Settings settings;
    protected Context context;

    public void setServletContext(ServletContext sContext) {
        this.servletContext = sContext;
    }

    protected void init() throws Exception {
        if (this.settings == null) {
            throw new IllegalArgumentException("Settings object is missing.");
        }
        ComponentContext appContext = new ComponentContext();
        appContext.put("environment-context", new HttpContext(this.servletContext));
        appContext.put("work-directory", new File(this.settings.getWorkDirectory()));
        appContext.put("cache-directory", new File(this.settings.getCacheDirectory()));
        appContext.put("default-encoding", this.settings.getFormEncoding());
        this.context = appContext;
    }

    public Object getObject() throws Exception {
        return this.context;
    }

    public Class getObjectType() {
        return Context.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

