/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;
import org.apache.cocoon.configuration.Settings;

public class PipelineNodeBuilder
extends AbstractParentProcessingNodeBuilder {
    private static final String ATTRIBUTE_INTERNAL_ONLY = "internal-only";
    private static final String PROPERTY_SITEMAP_INTERNALONLY = "org.apache.cocoon.sitemap.internalonly.disable";
    protected boolean ignoreInternalOnly;

    public void setBuilder(TreeBuilder treeBuilder) {
        super.setBuilder(treeBuilder);
        this.ignoreInternalOnly = false;
        Settings settings = (Settings)treeBuilder.getWebApplicationContext().getBean(Settings.ROLE);
        String value = settings.getProperty(PROPERTY_SITEMAP_INTERNALONLY);
        if (value != null) {
            this.ignoreInternalOnly = Boolean.valueOf(value);
        }
    }

    protected boolean hasParameters() {
        return true;
    }

    public ProcessingNode buildNode(Configuration config) throws Exception {
        String type = this.treeBuilder.getTypeForStatement(config, ProcessingPipeline.ROLE);
        PipelineNode node = new PipelineNode(type);
        this.treeBuilder.setupNode(node, config);
        if (this.ignoreInternalOnly) {
            node.setInternalOnly(false);
        } else {
            node.setInternalOnly(config.getAttributeAsBoolean(ATTRIBUTE_INTERNAL_ONLY, false));
        }
        HandleErrorsNode handler = null;
        Configuration[] childConfigs = config.getChildren();
        ArrayList<ProcessingNode> children = new ArrayList<ProcessingNode>();
        for (int i = 0; i < childConfigs.length; ++i) {
            Configuration childConfig = childConfigs[i];
            if (!this.isChild(childConfig)) continue;
            ProcessingNodeBuilder builder = this.treeBuilder.createNodeBuilder(childConfig);
            if (builder instanceof HandleErrorsNodeBuilder) {
                if (handler != null) {
                    throw new ConfigurationException("Duplicate <handle-errors> at " + handler.getLocation());
                }
                handler = (HandleErrorsNode)builder.buildNode(childConfig);
                continue;
            }
            children.add(builder.buildNode(childConfig));
        }
        node.setChildren(PipelineNodeBuilder.toNodeArray(children));
        node.setErrorHandler(handler);
        return node;
    }
}

