/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.util.location.Location;

public class CallNode
extends AbstractProcessingNode
implements ParameterizableProcessingNode {
    private Map parameters;
    private VariableResolver resourceName;
    private CategoryNode resources;

    public CallNode() {
        super(null);
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setResource(CategoryNode resources, VariableResolver resourceName) throws Exception {
        this.resourceName = resourceName;
        this.resources = resources;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        boolean bl;
        Map objectModel = env.getObjectModel();
        String name = this.resourceName.resolve(context, objectModel);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Calling resource '" + name + "'"));
        }
        Map params = VariableResolver.buildMap(this.parameters, context, objectModel);
        params = this.executor.pushVariables((ExecutionContext)this, objectModel, null, params);
        context.pushMap(null, params);
        try {
            bl = this.resources.invokeByName(name, env, context);
            Object var8_8 = null;
        }
        catch (Exception e) {
            try {
                throw ProcessingException.throwLocated((String)("Sitemap: error calling resource '" + name + "'"), (Throwable)e, (Location)this.getLocation());
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.executor.popVariables((ExecutionContext)this, objectModel);
                context.popMap();
                throw throwable;
            }
        }
        this.executor.popVariables((ExecutionContext)this, objectModel);
        context.popMap();
        return bl;
    }
}

