/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActionSetNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.util.location.Location;

public class ActTypeNode
extends SimpleSelectorProcessingNode
implements ParameterizableProcessingNode {
    private Map parameters;
    protected VariableResolver source;
    protected String name;
    protected boolean inActionSet;

    public ActTypeNode(String type, VariableResolver source, String name, boolean inActionSet) {
        super(Action.ROLE + "Selector", type);
        this.source = source;
        this.name = name;
        this.inActionSet = inActionSet;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        Map objectModel = env.getObjectModel();
        String resolvedSource = this.source.resolve(context, objectModel);
        Parameters resolvedParams = VariableResolver.buildParameters(this.parameters, context, objectModel);
        if (this.inActionSet) {
            Parameters callerParams = (Parameters)env.getAttribute(ActionSetNode.CALLER_PARAMETERS);
            if (resolvedParams == Parameters.EMPTY_PARAMETERS) {
                resolvedParams = callerParams;
            } else if (callerParams != Parameters.EMPTY_PARAMETERS) {
                Parameters newParams = new Parameters();
                newParams.merge(resolvedParams);
                newParams.merge(callerParams);
                resolvedParams = newParams;
            }
        }
        Redirector redirector = context.getRedirector();
        SourceResolver resolver = EnvironmentHelper.getCurrentProcessor().getSourceResolver();
        try {
            Map actionResult;
            Action action = (Action)this.getComponent();
            try {
                actionResult = this.executor.invokeAction((ExecutionContext)this, objectModel, action, redirector, resolver, resolvedSource, resolvedParams);
            }
            finally {
                this.releaseComponent(action);
            }
            if (redirector.hasRedirected()) {
                return true;
            }
            if (actionResult != null && this.children != null) {
                boolean result = this.invokeNodes(this.children, env, context, this.name, actionResult);
                if (this.inActionSet) {
                    Map childMap = (Map)env.getAttribute(ActionSetNode.ACTION_RESULTS);
                    if (childMap != null) {
                        HashMap newResults = new HashMap(childMap);
                        newResults.putAll(actionResult);
                        env.setAttribute(ActionSetNode.ACTION_RESULTS, newResults);
                    } else {
                        env.setAttribute(ActionSetNode.ACTION_RESULTS, (Object)actionResult);
                    }
                }
                return result;
            }
        }
        catch (Exception e) {
            throw ProcessingException.throwLocated((String)"Sitemap: error invoking action", (Throwable)e, (Location)this.getLocation());
        }
        return false;
    }
}

