/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.JXPathHelper;
import org.apache.cocoon.components.modules.input.JXPathHelperConfiguration;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPathXMLFileModule
extends AbstractInputModule
implements Serviceable,
ThreadSafe {
    public static final String ROLE = Store.ROLE + "/XPathXMLFileTransientStore";
    protected JXPathHelperConfiguration configuration;
    String staticConfLocation;
    private Store cache;
    private String cacheParm;
    private Boolean cacheSource;
    private String reloadParm;
    private Boolean reloadSource;
    boolean reloadAll;
    private boolean cacheExpressions;
    private boolean needsResolve;
    protected String parameter;
    private String src;
    protected SourceResolver resolver;
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = JXPathHelper.setup((Configuration)config);
        this.staticConfLocation = config.getLocation();
        Configuration roleConfig = config.getChild("cache-role", true);
        boolean cacheAll = config.getChild("cacheable").getValueAsBoolean(true);
        this.reloadAll = config.getChild("reloadable").getValueAsBoolean(true);
        String cacheRole = roleConfig.getValue(ROLE);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Using cache " + cacheRole));
        }
        try {
            this.cache = (Store)this.manager.lookup(cacheRole);
        }
        catch (ServiceException ce) {
            throw new ConfigurationException("Unable to lookup cache: " + cacheRole, (Throwable)ce);
        }
        Configuration fileConfig = config.getChild("file");
        this.src = fileConfig.getAttribute("src");
        this.cacheParm = fileConfig.getAttribute("cacheable", null);
        this.reloadParm = fileConfig.getAttribute("reloadable", null);
        this.cacheSource = this.cacheParm == null ? Boolean.valueOf(cacheAll) : (VariableResolverFactory.needsResolve((String)this.cacheParm) ? null : Boolean.valueOf(this.cacheParm));
        this.reloadSource = this.reloadParm == null ? Boolean.valueOf(this.reloadAll) : (VariableResolverFactory.needsResolve((String)this.reloadParm) ? null : Boolean.valueOf(this.reloadParm));
        this.cacheExpressions = config.getChild("cache-expressions").getValueAsBoolean(true);
        this.needsResolve = VariableResolverFactory.needsResolve((String)this.src);
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.cache);
            this.resolver = null;
            this.cache = null;
            this.manager = null;
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.getAttribute(name, modeConf, objectModel, false);
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, true);
        return result != null ? (Object[])result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Object getAttribute(String name, Configuration modeConf, Map objectModel, boolean getValues) throws ConfigurationException {
        Object result;
        VariableResolver varResolver;
        if (modeConf != null) {
            name = modeConf.getChild("parameter").getValue(this.parameter != null ? this.parameter : name);
        }
        boolean hasDynamicConf = false;
        Configuration fileConf = null;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            fileConf = modeConf.getChild("file", false);
            if (fileConf == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Missing 'file' child element at " + modeConf.getLocation()));
                }
            } else {
                hasDynamicConf = true;
            }
        }
        String src = this.src;
        Boolean cacheSource = this.cacheSource;
        Object reloadSource = this.cacheSource;
        boolean needsResolve = this.needsResolve;
        String cacheParm = this.cacheParm;
        String reloadParm = this.reloadParm;
        if (hasDynamicConf) {
            src = fileConf.getAttribute("src");
            cacheParm = fileConf.getAttribute("cacheable", this.cacheParm);
            reloadParm = fileConf.getAttribute("reloadable", this.reloadParm);
            if (cacheParm == null) {
                cacheSource = this.cacheSource;
            } else if (VariableResolverFactory.needsResolve((String)cacheParm)) {
                cacheSource = null;
                if (cacheSource == null) {
                    try {
                        varResolver = VariableResolverFactory.getResolver((String)cacheParm, (ServiceManager)this.manager);
                        cacheSource = Boolean.valueOf(varResolver.resolve(objectModel));
                    }
                    catch (PatternException pe) {
                        throw new ConfigurationException("Unable to resolve " + cacheParm, (Throwable)pe);
                    }
                }
            } else {
                cacheSource = Boolean.valueOf(cacheParm);
            }
            reloadSource = reloadParm == null ? this.reloadSource : (VariableResolverFactory.needsResolve((String)reloadParm) ? null : Boolean.valueOf(reloadParm));
            needsResolve = true;
        }
        if (cacheSource == null) {
            try {
                varResolver = VariableResolverFactory.getResolver((String)cacheParm, (ServiceManager)this.manager);
                cacheSource = Boolean.valueOf(varResolver.resolve(objectModel));
            }
            catch (PatternException pe) {
                throw new ConfigurationException("Unable to resolve " + cacheParm, (Throwable)pe);
            }
        }
        if (reloadSource == null) {
            try {
                varResolver = VariableResolverFactory.getResolver((String)reloadParm, (ServiceManager)this.manager);
                reloadSource = Boolean.valueOf(varResolver.resolve(objectModel));
            }
            catch (PatternException pe) {
                throw new ConfigurationException("Unable to resolve " + reloadParm, (Throwable)pe);
            }
        }
        if (src == null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer().append("No source specified");
            if (modeConf != null) {
                string = ", either dynamically in " + modeConf.getLocation() + ", or ";
                throw new ConfigurationException(stringBuffer.append(string).append(" statically in ").append(this.staticConfLocation).toString());
            }
            string = "";
            throw new ConfigurationException(stringBuffer.append(string).append(" statically in ").append(this.staticConfLocation).toString());
        }
        if (needsResolve) {
            try {
                varResolver = VariableResolverFactory.getResolver((String)src, (ServiceManager)this.manager);
                src = varResolver.resolve(objectModel);
            }
            catch (PatternException pe) {
                throw new ConfigurationException("Error resolving variables for " + src, (Throwable)pe);
            }
        }
        if (cacheSource.booleanValue()) {
            Map cache;
            DocumentInfo info = (DocumentInfo)this.cache.get((Object)src);
            if (info == null || ((Boolean)reloadSource).booleanValue() && !info.isValid()) {
                Source docSource = null;
                try {
                    try {
                        docSource = this.resolver.resolveURI(src);
                        DocumentInfo newInfo = new DocumentInfo(src, SourceUtil.toDOM((ServiceManager)this.manager, (Source)docSource), docSource.getValidity(), this.cacheExpressions, this.resolver);
                        Store store = this.cache;
                        // MONITORENTER : store
                        DocumentInfo cachedInfo = (DocumentInfo)this.cache.get((Object)src);
                        if (cachedInfo == null || cachedInfo == info) {
                            this.cache.store((Object)src, (Object)newInfo);
                            info = newInfo;
                        } else {
                            info = cachedInfo;
                        }
                        // MONITOREXIT : store
                    }
                    catch (MalformedURLException mue) {
                        throw new ConfigurationException("Unable to resolve " + src, (Throwable)mue);
                    }
                    catch (IOException ioe) {
                        throw new ConfigurationException("Unable to access" + src, (Throwable)ioe);
                    }
                    catch (ProcessingException pe) {
                        throw new ConfigurationException("Unable to process " + src, (Throwable)pe);
                    }
                    catch (SAXException se) {
                        throw new ConfigurationException("Error processing XML document " + src, (Throwable)se);
                    }
                    Object var21_32 = null;
                    if (docSource != null) {
                        this.resolver.release(docSource);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_33 = null;
                    if (docSource == null) throw throwable;
                    this.resolver.release(docSource);
                    throw throwable;
                }
            }
            if (!info.cacheExpressions) {
                result = this.getResult(name, info.document, modeConf, getValues);
                if (!this.getLogger().isDebugEnabled()) return result;
                this.getLogger().debug((Object)("for " + name + " result is " + result));
                return result;
            }
            Map map = cache = getValues ? info.expressionValuesCache : info.expressionCache;
            // MONITORENTER : map
            if (cache.containsKey(name)) {
                result = cache.get(name);
                if (!this.getLogger().isDebugEnabled()) return result;
                this.getLogger().debug((Object)("for " + name + " using cached result " + result));
                return result;
            } else {
                result = this.getResult(name, info.document, modeConf, getValues);
                if (result != null) {
                    cache.put(name, result);
                    if (!this.getLogger().isDebugEnabled()) return result;
                    this.getLogger().debug((Object)("for " + name + " newly caching result " + result));
                    return result;
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("for " + name + " result is null"));
                }
            }
            // MONITOREXIT : map
            return result;
        }
        Source docSource = null;
        try {
            block56: {
                try {
                    docSource = this.resolver.resolveURI(src);
                    result = this.getResult(name, SourceUtil.toDOM((ServiceManager)this.manager, (Source)docSource), modeConf, getValues);
                    if (!this.getLogger().isDebugEnabled()) break block56;
                    this.getLogger().debug((Object)("for " + name + " result is " + result));
                }
                catch (MalformedURLException mue) {
                    throw new ConfigurationException("Unable to resolve " + src, (Throwable)mue);
                }
                catch (IOException ioe) {
                    throw new ConfigurationException("Unable to access" + src, (Throwable)ioe);
                }
                catch (ProcessingException pe) {
                    throw new ConfigurationException("Unable to process " + src, (Throwable)pe);
                }
                catch (SAXException se) {
                    throw new ConfigurationException("Error processing XML document " + src, (Throwable)se);
                }
            }
            Object var24_35 = null;
            if (docSource == null) return result;
            this.resolver.release(docSource);
            return result;
        }
        catch (Throwable throwable) {
            Object var24_36 = null;
            if (docSource == null) throw throwable;
            this.resolver.release(docSource);
            throw throwable;
        }
    }

    private Object getResult(String name, Document document, Configuration modeConf, boolean getValues) throws ConfigurationException {
        Object result = getValues ? JXPathHelper.getAttributeValues((String)name, (Configuration)modeConf, (JXPathHelperConfiguration)this.configuration, (Object)document) : JXPathHelper.getAttributeValue((String)name, (Configuration)modeConf, (JXPathHelperConfiguration)this.configuration, (Object)document);
        return result;
    }

    private static class DocumentInfo {
        private boolean cacheExpressions;
        private final String uri;
        private final SourceValidity validity;
        private final SourceResolver resolver;
        private final Document document;
        private Map expressionCache;
        private Map expressionValuesCache;

        public DocumentInfo(String uri, Document doc, SourceValidity validity, boolean cacheExpressions, SourceResolver resolver) {
            this.cacheExpressions = cacheExpressions;
            if (cacheExpressions) {
                this.expressionCache = new ReferenceMap(1, 1);
                this.expressionValuesCache = new ReferenceMap(1, 1);
            }
            this.resolver = resolver;
            this.uri = uri;
            this.document = doc;
            this.validity = validity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isValid() {
            Source src = null;
            boolean result = true;
            try {
                block5: {
                    try {
                        int valid;
                        int n = valid = this.validity == null ? -1 : this.validity.isValid();
                        if (valid == 0) {
                            src = this.resolver.resolveURI(this.uri);
                            SourceValidity newValidity = src.getValidity();
                            valid = this.validity.isValid(newValidity);
                        }
                        if (valid == 1) break block5;
                        result = false;
                    }
                    catch (Exception ex) {
                        result = false;
                        Object var6_7 = null;
                        if (src == null) return result;
                        this.resolver.release(src);
                        return result;
                    }
                }
                Object var6_6 = null;
                if (src == null) return result;
                this.resolver.release(src);
                return result;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (src == null) throw throwable;
                this.resolver.release(src);
                throw throwable;
            }
        }
    }
}

