/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.forms.formmodel.tree.SourceTreeModelDefinition;
import org.apache.cocoon.forms.formmodel.tree.TreeModelDefinition;
import org.apache.cocoon.forms.formmodel.tree.builder.TreeModelDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Element;

public class SourceTreeModelDefinitionBuilder
implements TreeModelDefinitionBuilder {
    private SourceResolver sourceResolver;

    public TreeModelDefinition build(Element modelElt) throws Exception {
        Element dirSet;
        SourceTreeModelDefinition definition = new SourceTreeModelDefinition();
        definition.setURL(DomHelper.getAttribute(modelElt, "src"));
        Element fileSet = DomHelper.getChildElement(modelElt, "http://apache.org/cocoon/forms/1.0#definition", "fileset");
        if (fileSet != null) {
            definition.setFilePatterns(this.getPatterns(fileSet, "include"), this.getPatterns(fileSet, "exclude"));
        }
        if ((dirSet = DomHelper.getChildElement(modelElt, "http://apache.org/cocoon/forms/1.0#definition", "dirset")) != null) {
            definition.setDirectoryPatterns(this.getPatterns(dirSet, "include"), this.getPatterns(dirSet, "exclude"));
        }
        definition.setSourceResolver(this.sourceResolver);
        return definition;
    }

    protected List getPatterns(Element parent, String name) throws Exception {
        Element[] children = DomHelper.getChildElements(parent, "http://apache.org/cocoon/forms/1.0#definition", name);
        if (children.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < children.length; ++i) {
            String pattern = DomHelper.getAttribute(children[i], "pattern");
            result.add(pattern);
        }
        return result;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }
}

