/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.EventListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeModelEvent;
import org.apache.cocoon.forms.formmodel.tree.TreeModelListener;
import org.apache.cocoon.forms.formmodel.tree.TreePath;

public class TreeModelHelper {
    private TreeModel model;
    private TreeModelListener listener;

    public TreeModelHelper(TreeModel model) {
        this.model = model;
    }

    public Object getNode(TreePath path) {
        if (path == TreePath.ROOT_PATH) {
            return this.model.getRoot();
        }
        Object parent = this.getNode(path.getParentPath());
        if (parent == null) {
            return null;
        }
        return this.model.getChild(parent, path.getLastKey());
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.listener = EventMulticaster.add(this.listener, listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.listener = EventMulticaster.remove(this.listener, listener);
    }

    boolean hasListeners() {
        return this.listener != null;
    }

    public void fireTreeStructureChanged(TreePath path) {
        if (this.hasListeners()) {
            TreeModelEvent event = new TreeModelEvent(this.model, path);
            this.listener.treeStructureChanged(event);
        }
    }

    private static class EventMulticaster
    extends WidgetEventMulticaster
    implements TreeModelListener {
        protected EventMulticaster(EventListener a, EventListener b) {
            super(a, b);
        }

        protected static EventListener addInternal(EventListener a, EventListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new EventMulticaster(a, b);
        }

        public static TreeModelListener add(TreeModelListener a, TreeModelListener b) {
            return (TreeModelListener)EventMulticaster.addInternal(a, b);
        }

        public static TreeModelListener remove(TreeModelListener l, TreeModelListener oldl) {
            return (TreeModelListener)EventMulticaster.removeInternal(l, oldl);
        }

        protected EventListener remove(EventListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            EventListener a2 = EventMulticaster.removeInternal(this.a, oldl);
            EventListener b2 = EventMulticaster.removeInternal(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return EventMulticaster.addInternal(a2, b2);
        }

        public void treeStructureChanged(TreeModelEvent event) {
            ((TreeModelListener)this.a).treeStructureChanged(event);
            ((TreeModelListener)this.b).treeStructureChanged(event);
        }
    }
}

