/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeModelHelper;
import org.apache.cocoon.forms.formmodel.tree.TreeModelListener;
import org.apache.cocoon.forms.formmodel.tree.TreePath;

public class DefaultTreeModel
implements TreeModel {
    public static final TreeModel UNSPECIFIED_MODEL = DefaultTreeModel.buildUnspecifiedModel();
    private TreeModelHelper helper = new TreeModelHelper(this);
    TreeNode root;

    public DefaultTreeModel(TreeNode root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public Collection getChildren(Object parent) {
        return ((TreeNode)parent).getChildren();
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public String getChildKey(Object parent, Object child) {
        return ((TreeNode)parent).getChildKey(child);
    }

    public Object getChild(Object parent, String key) {
        return ((TreeNode)parent).getChild(key);
    }

    public Object getNode(TreePath path) {
        return this.helper.getNode(path);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.helper.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.helper.removeTreeModelListener(l);
    }

    private static TreeModel buildUnspecifiedModel() {
        DefaultTreeNode root = new DefaultTreeNode("This tree has no model.");
        DefaultTreeNode parent = new DefaultTreeNode("Tree model should be defined...");
        root.add("explanation", parent);
        parent.add("1", new DefaultTreeNode("in the form definition using <fd:tree-model>"));
        parent.add("2", new DefaultTreeNode("by the application using flowscript, event listeners, etc."));
        return new DefaultTreeModel(root);
    }

    public static class DefaultTreeNode
    implements TreeNode {
        private Object data;
        private Map children;

        public DefaultTreeNode(Object data) {
            this.data = data;
        }

        public DefaultTreeNode(Object data, Map children) {
            this.data = data;
            this.children = children;
        }

        public Object getData() {
            return this.data;
        }

        public void add(String key, TreeNode node) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            this.children.put(key, node);
        }

        public Collection getChildren() {
            if (this.children == null) {
                return null;
            }
            return this.children.values();
        }

        public boolean isLeaf() {
            return this.children == null;
        }

        public String getChildKey(Object child) {
            Iterator iter = this.children.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!child.equals(entry.getValue())) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        public Object getChild(String key) {
            return this.children.get(key);
        }
    }

    public static interface TreeNode {
        public Collection getChildren();

        public boolean isLeaf();

        public String getChildKey(Object var1);

        public Object getChild(String var1);
    }
}

