/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.formmodel.ActionDefinition;
import org.apache.cocoon.forms.formmodel.EnhancedRepeater;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.RepeaterAction;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public abstract class RepeaterActionDefinition
extends ActionDefinition {
    private String name = null;

    public RepeaterActionDefinition() {
    }

    public RepeaterActionDefinition(String repeaterName) {
        this.name = repeaterName;
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof RepeaterActionDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not a RepeaterActionDefinition.", this.getLocation());
        }
        RepeaterActionDefinition other = (RepeaterActionDefinition)definition;
        this.name = other.name;
    }

    public Widget createInstance() {
        return new RepeaterAction(this);
    }

    public String getRepeaterName() {
        return this.name;
    }

    public static class ChangePageActionDefinition
    extends RepeaterActionDefinition {
        protected int method;
        public static final int FIRST = 0;
        public static final int PREV = 1;
        public static final int NEXT = 2;
        public static final int LAST = 3;
        public static final int CUSTOM = 4;

        public void initializeFrom(WidgetDefinition definition) throws Exception {
            super.initializeFrom(definition);
            if (!(definition instanceof ChangePageActionDefinition)) {
                throw new Exception("Definition to inherit from is not of the right type! (at " + this.getLocation() + ")");
            }
            ChangePageActionDefinition other = (ChangePageActionDefinition)definition;
            this.method = other.method;
        }

        public ChangePageActionDefinition(String repeaterName, int m) {
            super(repeaterName);
            this.method = m;
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ ChangePageActionDefinition this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    Repeater repeater = ((RepeaterAction)event.getSource()).getRepeater();
                    if (repeater instanceof EnhancedRepeater) {
                        EnhancedRepeater erep = (EnhancedRepeater)repeater;
                        int page = erep.getCurrentPage();
                        if (this.this$0.method == 0) {
                            page = 0;
                        } else if (this.this$0.method == 1 && page > 0) {
                            page = erep.getCurrentPage() - 1;
                        } else if (this.this$0.method == 2 && page < erep.getMaxPage()) {
                            page = erep.getCurrentPage() + 1;
                        } else if (this.this$0.method == 3) {
                            page = erep.getMaxPage();
                        } else if (this.this$0.method == 4) {
                            page = erep.getCustomPageWidgetValue();
                        } else {
                            return;
                        }
                        try {
                            if (repeater.validate()) {
                                erep.goToPage(page);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error switching page", e);
                        }
                    }
                }
            });
        }
    }

    public static class SortActionDefinition
    extends RepeaterActionDefinition {
        protected String field = null;

        public SortActionDefinition(String repeaterName, String field) {
            super(repeaterName);
            this.field = field;
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ SortActionDefinition this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    Repeater repeater = ((RepeaterAction)event.getSource()).getRepeater();
                    if (repeater instanceof EnhancedRepeater) {
                        EnhancedRepeater erep = (EnhancedRepeater)repeater;
                        try {
                            if (repeater.validate()) {
                                erep.sortBy(this.this$0.field);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error switching page", e);
                        }
                    }
                }
            });
        }
    }

    public static class InsertRowsActionDefinition
    extends RepeaterActionDefinition {
        protected String selectName;

        public void initializeFrom(WidgetDefinition definition) throws Exception {
            super.initializeFrom(definition);
            if (!(definition instanceof InsertRowsActionDefinition)) {
                throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an InsertRowsActionDefinition.", this.getLocation());
            }
            InsertRowsActionDefinition other = (InsertRowsActionDefinition)definition;
            this.selectName = other.selectName;
        }

        public InsertRowsActionDefinition(String repeaterName, String selectWidgetName) {
            super(repeaterName);
            this.selectName = selectWidgetName;
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ InsertRowsActionDefinition this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    Repeater repeater = ((RepeaterAction)event.getSource()).getRepeater();
                    boolean foundSelection = false;
                    for (int i = repeater.getSize() - 1; i >= 0; --i) {
                        Repeater.RepeaterRow row = repeater.getRow(i);
                        Widget selectWidget = row.getChild(this.this$0.selectName);
                        if (!Boolean.TRUE.equals(selectWidget.getValue())) continue;
                        repeater.addRow(i);
                        foundSelection = true;
                    }
                    if (!foundSelection) {
                        repeater.addRow();
                    }
                }
            });
        }
    }

    public static class AddRowActionDefinition
    extends RepeaterActionDefinition {
        private int insertRows;

        public AddRowActionDefinition(String repeaterName, int insertRows) {
            super(repeaterName);
            this.insertRows = insertRows;
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddRowActionDefinition this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    Repeater repeater = ((RepeaterAction)event.getSource()).getRepeater();
                    if (repeater instanceof EnhancedRepeater) {
                        try {
                            ((EnhancedRepeater)repeater).goToPage(((EnhancedRepeater)repeater).getMaxPage());
                        }
                        catch (BindingException e) {
                            throw new RuntimeException("Error switching page", (Throwable)((Object)e));
                        }
                    }
                    for (int i = 0; i < AddRowActionDefinition.access$000(this.this$0); ++i) {
                        repeater.addRow();
                    }
                }
            });
        }

        static /* synthetic */ int access$000(AddRowActionDefinition x0) {
            return x0.insertRows;
        }
    }

    public static class DeleteRowsActionDefinition
    extends RepeaterActionDefinition {
        private String selectName;

        public DeleteRowsActionDefinition(String repeaterName, String selectName) {
            super(repeaterName);
            this.selectName = selectName;
        }

        public void initializeFrom(WidgetDefinition definition) throws Exception {
            super.initializeFrom(definition);
            if (!(definition instanceof DeleteRowsActionDefinition)) {
                throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not a DeleteRowsActionDefinition.", this.getLocation());
            }
            DeleteRowsActionDefinition other = (DeleteRowsActionDefinition)definition;
            this.selectName = other.selectName;
        }

        public boolean hasActionListeners() {
            return true;
        }

        public void fireActionEvent(ActionEvent event) {
            super.fireActionEvent(event);
            Repeater repeater = ((RepeaterAction)event.getSource()).getRepeater();
            for (int i = repeater.getSize() - 1; i >= 0; --i) {
                Repeater.RepeaterRow row = repeater.getRow(i);
                if (!Boolean.TRUE.equals(row.getChild(this.selectName).getValue())) continue;
                repeater.removeRow(i);
            }
            if (repeater instanceof EnhancedRepeater) {
                try {
                    ((EnhancedRepeater)repeater).refreshPage();
                }
                catch (BindingException e) {
                    throw new RuntimeException("Error refreshing repeater page", (Throwable)((Object)e));
                }
            }
        }
    }
}

