/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.OutputDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.ObjectUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Output
extends AbstractWidget
implements DataWidget,
ValueChangedListenerEnabled {
    private final OutputDefinition definition;
    private Object value;
    private ValueChangedListener listener;
    private static final String OUTPUT_EL = "output";
    private static final String VALUE_EL = "value";

    public Output(OutputDefinition definition) {
        super(definition);
        this.definition = definition;
        this.listener = definition.getValueChangedListener();
    }

    public Datatype getDatatype() {
        return this.definition.getDatatype();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public OutputDefinition getOutputDefinition() {
        return this.definition;
    }

    public void initialize() {
        Object value = this.definition.getInitialValue();
        if (value != null) {
            this.setValue(value);
        }
        super.initialize();
    }

    public void readFromRequest(FormContext formContext) {
    }

    public boolean validate() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public String getXMLElementName() {
        return OUTPUT_EL;
    }

    protected void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        SelectionList selectionList;
        if (this.value != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
            String stringValue = this.definition.getDatatype().convertToString(this.value, locale);
            contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if ((selectionList = this.definition.getSelectionList()) != null) {
            selectionList.generateSaxFragment(contentHandler, locale);
        }
        this.definition.getDatatype().generateSaxFragment(contentHandler, locale);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (object != null && !this.definition.getDatatype().getTypeClass().isAssignableFrom(object.getClass())) {
            throw new RuntimeException("Tried to set value of output widget \"" + this.getRequestParameterName() + "\" with an object of an incorrect type: " + "expected " + this.definition.getDatatype().getTypeClass() + ", received " + object.getClass() + ".");
        }
        if (!ObjectUtils.equals((Object)this.value, (Object)object)) {
            Object oldValue = this.value;
            this.value = object;
            if (this.hasValueChangedListeners() || this.getForm().hasFormHandler()) {
                this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, this.value));
            }
            this.getForm().addWidgetUpdate(this);
        }
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            if (this.listener != null) {
                this.listener.valueChanged((ValueChangedEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }
}

