/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.MessagesDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.StringMessage;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Messages
extends AbstractWidget {
    private static final String MESSAGES_EL = "messages";
    private static final String MESSAGE_EL = "message";
    private final MessagesDefinition definition;
    private ArrayList messages;

    protected Messages(MessagesDefinition definition) {
        super(definition);
        this.definition = definition;
        this.messages = new ArrayList();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
        if (this.getCombinedState().isAcceptingInputs()) {
            this.messages.clear();
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        this.wasValid = this.messages.size() == 0;
        return this.wasValid;
    }

    public void addMessage(String message) {
        this.messages.add(new StringMessage(message));
        this.getForm().addWidgetUpdate(this);
    }

    public void addMessage(XMLizable message) {
        this.messages.add(message);
        this.getForm().addWidgetUpdate(this);
    }

    public String getXMLElementName() {
        return MESSAGES_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            XMLizable message = (XMLizable)i.next();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", MESSAGE_EL, "fi:message", XMLUtils.EMPTY_ATTRIBUTES);
            message.toSAX(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", MESSAGE_EL, "fi:message");
        }
    }
}

