/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.GoogleMapDefinition;
import org.apache.cocoon.forms.formmodel.GoogleMapMarker;
import org.apache.cocoon.forms.formmodel.GoogleMapValue;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GoogleMap
extends AbstractWidget {
    private static final String GOOGLEMAP_FIELD_EL = "googlemap";
    private static final String VALUE_EL = "value";
    private static final String MARKERS_EL = "markers";
    private static final String MARKER_EL = "marker";
    private static final String USERMARKER_EL = "usermarker";
    private static final String MARKER_TEXT_EL = "text";
    private GoogleMapValue value;
    private final GoogleMapDefinition definition;

    public GoogleMap(GoogleMapDefinition definition) {
        super(definition);
        this.definition = definition;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void initialize() {
        GoogleMapValue value = this.definition.getInitialValue();
        if (value != null) {
            this.setValue(value);
        }
        super.initialize();
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        String prefix = this.getRequestParameterName();
        String paramLng = formContext.getRequest().getParameter(prefix + "_lng");
        String paramLat = formContext.getRequest().getParameter(prefix + "_lat");
        String paramZoom = formContext.getRequest().getParameter(prefix + "_zoom");
        String currentMarker = formContext.getRequest().getParameter(prefix + "_current");
        String userMarkerLng = formContext.getRequest().getParameter(prefix + "_usermarker-lng");
        String userMarkerLat = formContext.getRequest().getParameter(prefix + "_usermarker-lat");
        GoogleMapValue newValue = new GoogleMapValue();
        newValue.setLng(Float.valueOf(paramLng).floatValue());
        newValue.setLat(Float.valueOf(paramLat).floatValue());
        newValue.setZoom(Integer.valueOf(paramZoom));
        newValue.setCurrentMarker(Integer.valueOf(currentMarker));
        newValue.setMarkers(this.value.getMarkers());
        if (userMarkerLng != null && userMarkerLat != null) {
            try {
                GoogleMapMarker marker = new GoogleMapMarker();
                marker.setLng(Float.valueOf(userMarkerLng).floatValue());
                marker.setLat(Float.valueOf(userMarkerLat).floatValue());
                newValue.setUsermarker(marker);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        GoogleMapValue oldValue = this.value;
        this.value = newValue;
        if (!this.value.equals(oldValue)) {
            this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, this.value));
        }
    }

    public String getXMLElementName() {
        return GOOGLEMAP_FIELD_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        List markers;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "lng", "lng", "CDATA", this.value.getLng() + "");
        attributesImpl.addAttribute("", "lat", "lat", "CDATA", this.value.getLat() + "");
        attributesImpl.addAttribute("", "zoom", "zoom", "CDATA", this.value.getZoom() + "");
        attributesImpl.addAttribute("", "current", "current", "CDATA", this.value.getCurrentMarker() + "");
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)attributesImpl);
        if (this.value.getUsermarker() != null) {
            attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "lng", "lng", "CDATA", this.value.getUsermarker().getLng() + "");
            attributesImpl.addAttribute("", "lat", "lat", "CDATA", this.value.getUsermarker().getLat() + "");
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", USERMARKER_EL, "fi:usermarker", (Attributes)attributesImpl);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", USERMARKER_EL, "fi:usermarker");
        }
        if ((markers = this.value.getMarkers()) != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", MARKERS_EL, "fi:markers", (Attributes)new AttributesImpl());
            Iterator iter = markers.iterator();
            while (iter.hasNext()) {
                GoogleMapMarker marker = (GoogleMapMarker)iter.next();
                attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "lng", "lng", "CDATA", marker.getLng() + "");
                attributesImpl.addAttribute("", "lat", "lat", "CDATA", marker.getLat() + "");
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", MARKER_EL, "fi:marker", (Attributes)attributesImpl);
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", MARKER_TEXT_EL, "fi:text", (Attributes)new AttributesImpl());
                marker.getText().toSAX(contentHandler);
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", MARKER_TEXT_EL, "fi:text");
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", MARKER_EL, "fi:marker");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", MARKERS_EL, "fi:markers");
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (!(object instanceof GoogleMapValue)) {
            throw new RuntimeException("Cannot set value of googlemap \"" + this.getRequestParameterName() + "\" to a non-GoogleMapValue.");
        }
        GoogleMapValue oldValue = this.value;
        this.value = (GoogleMapValue)object;
        if (!this.value.equals(oldValue)) {
            Form form = this.getForm();
            form.addWidgetUpdate(this);
        }
    }

    public void broadcastEvent(WidgetEvent event) {
        if (!(event instanceof ValueChangedEvent)) {
            super.broadcastEvent(event);
        }
    }
}

