/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.forms.formmodel.CaptchaFieldDefinition;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CaptchaField
extends Field {
    public static final String SESSION_ATTR_PREFIX = "captcha-";
    private static final String IMAGE_EL = "captcha-image";
    private static final String SECRET_CHARS = "abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
    private static final int SESSION_ATTR_NAME_LENGTH = 6;
    private int length;
    private ProcessInfoProvider processInfoProvider;
    protected static final SecureRandom random;

    public CaptchaField(CaptchaFieldDefinition fieldDefinition, ProcessInfoProvider processInfoProvider) {
        super(fieldDefinition);
        this.length = fieldDefinition.getLength();
        this.processInfoProvider = processInfoProvider;
    }

    private String generateSecret() {
        StringBuffer secret = new StringBuffer(this.length);
        for (int n = 0; n < this.length; ++n) {
            int randomnumber = random.nextInt(SECRET_CHARS.length());
            secret.append(SECRET_CHARS.charAt(randomnumber));
        }
        return secret.toString();
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        super.generateItemSaxFragment(contentHandler, locale);
        byte[] bytes = new byte[6];
        char[] result = new char[bytes.length * 2];
        random.nextBytes(bytes);
        for (int i = 0; i < 6; ++i) {
            byte ch = bytes[i];
            result[2 * i] = Character.forDigit(Math.abs(ch >> 4), 16);
            result[2 * i + 1] = Character.forDigit(Math.abs(ch & 0xF), 16);
        }
        String id = new String(result);
        HttpSession session = this.processInfoProvider.getRequest().getSession(true);
        String secret = this.generateSecret();
        session.setAttribute(SESSION_ATTR_PREFIX + id, (Object)secret);
        this.setAttribute("secret", secret);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "id", "id", "PCDATA", id);
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", IMAGE_EL, "fi:captcha-image", (Attributes)attrs);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", IMAGE_EL, "fi:captcha-image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SecureRandom sr = null;
        try {
            sr = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                sr = SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No random number generator available", e);
            }
        }
        finally {
            random = sr;
        }
        random.setSeed(System.currentTimeMillis());
    }
}

