/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import com.ibm.icu.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.RepeaterEvent;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.formmodel.CalculatedFieldAlgorithm;
import org.apache.cocoon.forms.formmodel.CalculatedFieldDefinition;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.WidgetFinder;

public class CalculatedField
extends Field {
    private CalculatedFieldAlgorithm algorithm = null;
    private WidgetFinder finder = null;
    private RecalculateValueListener mockListener = new RecalculateValueListener();
    private boolean needRecaulculate = false;
    private boolean calculating = false;

    protected CalculatedField(CalculatedFieldDefinition definition) {
        super(definition);
        this.algorithm = definition.getAlgorithm();
    }

    public void initialize() {
        super.initialize();
        Iterator triggers = this.algorithm.getTriggerWidgets();
        this.finder = new WidgetFinder(this.getParent(), triggers, true);
        this.finder.addRepeaterListener(new InstallHandlersListener());
        this.installHandlers();
    }

    protected void installHandlers() {
        List adds = this.finder.getNewAdditions();
        Iterator iter = adds.iterator();
        while (iter.hasNext()) {
            Widget widget = (Widget)iter.next();
            if (!(widget instanceof ValueChangedListenerEnabled)) continue;
            ((ValueChangedListenerEnabled)((Object)widget)).addValueChangedListener(this.mockListener);
        }
    }

    protected void readFromRequest(String newEnteredValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (!this.calculating && this.needRecaulculate) {
            this.calculating = true;
            try {
                super.setValue(this.recalculate());
            }
            finally {
                this.calculating = false;
            }
        }
        return super.getValue();
    }

    protected Object recalculate() {
        Object ret = this.algorithm.calculate(this.getForm(), this.getParent(), this.getDatatype());
        this.needRecaulculate = false;
        try {
            ret = this.convert(ret, this.getDatatype());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected Object convert(Object ret, Datatype datatype) throws Exception {
        Class target = datatype.getTypeClass();
        if (ret instanceof Number) {
            Number number = (Number)ret;
            if (target.equals(BigDecimal.class)) {
                return number;
            }
            if (target.equals(Double.class)) {
                ret = new Double(number.doubleValue());
            } else if (target.equals(Float.class)) {
                ret = new Float(number.floatValue());
            } else if (target.equals(Integer.class)) {
                ret = new Integer(number.intValue());
            } else if (target.equals(Long.class)) {
                ret = new Long(number.longValue());
            } else if (target.equals(String.class)) {
                ret = number.toString();
            }
            return ret;
        }
        if (ret instanceof String) {
            if (Number.class.isAssignableFrom(target)) {
                ret = target.getConstructor(String.class).newInstance(ret);
            }
            return ret;
        }
        ConversionResult result = this.getDatatype().convertFromString(ret.toString(), this.getForm().getLocale());
        if (result.isSuccessful()) {
            ret = result.getResult();
        }
        return ret;
    }

    public CalculatedFieldAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    class InstallHandlersListener
    implements RepeaterListener {
        InstallHandlersListener() {
        }

        public void repeaterModified(RepeaterEvent event) {
            CalculatedField.this.needRecaulculate = true;
            CalculatedField.this.installHandlers();
            CalculatedField.this.getValue();
        }
    }

    class RecalculateValueListener
    implements ValueChangedListener {
        RecalculateValueListener() {
        }

        public void valueChanged(ValueChangedEvent event) {
            CalculatedField.this.needRecaulculate = true;
            CalculatedField.this.getValue();
        }
    }
}

