/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.event.CreateListener;
import org.apache.cocoon.forms.event.WidgetListener;
import org.apache.cocoon.forms.event.WidgetListenerBuilder;
import org.apache.cocoon.forms.expression.ExpressionManager;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.NewDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.validation.WidgetValidatorBuilder;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractWidgetDefinitionBuilder
implements WidgetDefinitionBuilder {
    protected Map widgetDefinitionBuilders;
    protected Map widgetValidatorBuilders;
    protected Map widgetListenerBuilders;
    protected DatatypeManager datatypeManager;
    protected ExpressionManager expressionManager;

    public WidgetDefinition buildWidgetDefinition(Element widgetElement) throws Exception {
        throw new UnsupportedOperationException("Please use the other signature with WidgetDefinitionBuilderContext!");
    }

    protected void setupDefinition(Element widgetElement, AbstractWidgetDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        definition.setLocation(DomHelper.getLocationObject(widgetElement));
        if (context.getSuperDefinition() != null) {
            definition.initializeFrom(context.getSuperDefinition());
        }
        this.setCommonProperties(widgetElement, definition);
        this.setValidators(widgetElement, definition);
        this.setCreateListeners(widgetElement, definition);
    }

    protected void setCommonProperties(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Element[] attrs;
        Element attrContainer;
        if (widgetDefinition instanceof FormDefinition) {
            widgetDefinition.setId(DomHelper.getAttribute(widgetElement, "id", ""));
        } else {
            String id = DomHelper.getAttribute(widgetElement, "id");
            if (id.indexOf(47) != -1 || id.indexOf(46) != -1) {
                throw new FormsException("A widget name cannot contain '.' or '/' as this conflicts with widget paths.", DomHelper.getLocationObject(widgetElement));
            }
            if (id.indexOf(58) != -1 && !(widgetDefinition instanceof NewDefinition)) {
                throw new FormsException("A widget name cannot contain ':' as this conflicts with library prefixes", DomHelper.getLocationObject(widgetElement));
            }
            widgetDefinition.setId(id);
        }
        String stateValue = DomHelper.getAttribute(widgetElement, "state", null);
        if (stateValue != null) {
            WidgetState state = WidgetState.stateForName(stateValue);
            if (state == null) {
                throw new FormsException("Unknown value '" + stateValue + "' for state attribute.", DomHelper.getLocationObject(widgetElement));
            }
            widgetDefinition.setState(state);
        }
        if ((attrContainer = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "attributes", false)) != null && (attrs = DomHelper.getChildElements(attrContainer, "http://apache.org/cocoon/forms/1.0#definition", "attribute")) != null && attrs.length > 0) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (int i = 0; i < attrs.length; ++i) {
                attrMap.put(DomHelper.getAttribute(attrs[i], "name"), DomHelper.getAttribute(attrs[i], "value"));
            }
            widgetDefinition.setAttributes(attrMap);
        }
    }

    protected WidgetDefinition buildAnotherWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        String widgetName = widgetElement.getLocalName();
        WidgetDefinitionBuilder builder = (WidgetDefinitionBuilder)this.widgetDefinitionBuilders.get(widgetName);
        if (builder == null) {
            throw new FormsException("Unknown kind of widget '" + widgetName + "'.", DomHelper.getLocationObject(widgetElement));
        }
        WidgetDefinition def = builder.buildWidgetDefinition(widgetElement, context);
        if (DomHelper.getAttributeAsBoolean(widgetElement, "register", false)) {
            context.getLocalLibrary().addDefinition(def);
        }
        return def;
    }

    protected List buildEventListeners(Element widgetElement, String elementName, Class listenerClass) throws Exception {
        ArrayList<WidgetListener> result = null;
        Element listenersElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", elementName);
        if (listenersElement != null) {
            NodeList list = listenersElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                Element listenerElement = (Element)list.item(i);
                WidgetListenerBuilder builder = (WidgetListenerBuilder)this.widgetListenerBuilders.get(listenerElement.getLocalName());
                if (builder == null) {
                    throw new FormsException("Unknown kind of eventlistener '" + listenerElement.getLocalName() + "'.", DomHelper.getLocationObject(listenerElement));
                }
                WidgetListener listener = builder.buildListener(listenerElement, listenerClass);
                if (result == null) {
                    result = new ArrayList<WidgetListener>();
                }
                result.add(listener);
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    protected void setDisplayData(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        String[] names = new String[]{"label", "help", "hint"};
        HashMap<String, XMLizable> displayData = new HashMap<String, XMLizable>(names.length);
        for (int i = 0; i < names.length; ++i) {
            XMLizable data = null;
            Element dataElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", names[i]);
            if (dataElement != null) {
                data = DomHelper.compileElementContent(dataElement);
            }
            displayData.put(names[i], data);
        }
        widgetDefinition.setDisplayData(displayData);
    }

    protected void setValidators(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Element validatorElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "validation");
        if (validatorElement != null) {
            NodeList list = validatorElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                Element element = (Element)list.item(i);
                String name = element.getLocalName();
                WidgetValidatorBuilder builder = (WidgetValidatorBuilder)this.widgetValidatorBuilders.get(name);
                if (builder == null) {
                    throw new FormsException("Unknown kind of validator '" + name + "'.", DomHelper.getLocationObject(element));
                }
                widgetDefinition.addValidator(builder.build(element, widgetDefinition));
            }
        }
    }

    protected void setCreateListeners(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Iterator i = this.buildEventListeners(widgetElement, "on-create", CreateListener.class).iterator();
        while (i.hasNext()) {
            widgetDefinition.addCreateListener((CreateListener)i.next());
        }
    }

    public void setWidgetDefinitionBuilders(Map widgetDefinitionBuilders) {
        this.widgetDefinitionBuilders = widgetDefinitionBuilders;
    }

    public void setWidgetValidatorBuilders(Map widgetValidatorBuilders) {
        this.widgetValidatorBuilders = widgetValidatorBuilders;
    }

    public void setWidgetListenerBuilders(Map widgetListenerBuilders) {
        this.widgetListenerBuilders = widgetListenerBuilders;
    }

    public void setDatatypeManager(DatatypeManager datatypeManager) {
        this.datatypeManager = datatypeManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

